package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{MFA, BucketName, AccountId}
import scala.jdk.CollectionConverters.*
final case class PutBucketVersioningRequest(
    accountId: AccountId,
    bucket: BucketName,
    mfa: Optional[MFA] = Optional.Absent,
    versioningConfiguration: zio.aws.s3control.model.VersioningConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutBucketVersioningRequest = {
    import PutBucketVersioningRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutBucketVersioningRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(mfa.map(value => MFA.unwrap(value): java.lang.String))(
        _.mfa
      )
      .versioningConfiguration(versioningConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.PutBucketVersioningRequest.ReadOnly =
    zio.aws.s3control.model.PutBucketVersioningRequest.wrap(buildAwsValue())
}
object PutBucketVersioningRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutBucketVersioningRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.PutBucketVersioningRequest =
      zio.aws.s3control.model.PutBucketVersioningRequest(
        accountId,
        bucket,
        mfa.map(value => value),
        versioningConfiguration.asEditable
      )
    def accountId: AccountId
    def bucket: BucketName
    def mfa: Optional[MFA]
    def versioningConfiguration
        : zio.aws.s3control.model.VersioningConfiguration.ReadOnly
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getMfa: ZIO[Any, AwsError, MFA] = AwsError.unwrapOptionField("mfa", mfa)
    def getVersioningConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.VersioningConfiguration.ReadOnly
    ] = ZIO.succeed(versioningConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutBucketVersioningRequest
  ) extends zio.aws.s3control.model.PutBucketVersioningRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val mfa: Optional[MFA] = zio.aws.core.internal
      .optionalFromNullable(impl.mfa())
      .map(value => zio.aws.s3control.model.primitives.MFA(value))
    override val versioningConfiguration
        : zio.aws.s3control.model.VersioningConfiguration.ReadOnly =
      zio.aws.s3control.model.VersioningConfiguration
        .wrap(impl.versioningConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutBucketVersioningRequest
  ): zio.aws.s3control.model.PutBucketVersioningRequest.ReadOnly = new Wrapper(
    impl
  )
}
