package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{BucketName, AccountId}
import scala.jdk.CollectionConverters.*
final case class PutBucketReplicationRequest(
    accountId: AccountId,
    bucket: BucketName,
    replicationConfiguration: zio.aws.s3control.model.ReplicationConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutBucketReplicationRequest = {
    import PutBucketReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutBucketReplicationRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .replicationConfiguration(replicationConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.PutBucketReplicationRequest.ReadOnly =
    zio.aws.s3control.model.PutBucketReplicationRequest.wrap(buildAwsValue())
}
object PutBucketReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutBucketReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.PutBucketReplicationRequest =
      zio.aws.s3control.model.PutBucketReplicationRequest(
        accountId,
        bucket,
        replicationConfiguration.asEditable
      )
    def accountId: AccountId
    def bucket: BucketName
    def replicationConfiguration
        : zio.aws.s3control.model.ReplicationConfiguration.ReadOnly
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getReplicationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.ReplicationConfiguration.ReadOnly
    ] = ZIO.succeed(replicationConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutBucketReplicationRequest
  ) extends zio.aws.s3control.model.PutBucketReplicationRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val replicationConfiguration
        : zio.aws.s3control.model.ReplicationConfiguration.ReadOnly =
      zio.aws.s3control.model.ReplicationConfiguration
        .wrap(impl.replicationConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutBucketReplicationRequest
  ): zio.aws.s3control.model.PutBucketReplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
