package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{BucketName, AccountId}
import scala.jdk.CollectionConverters.*
final case class PutBucketLifecycleConfigurationRequest(
    accountId: AccountId,
    bucket: BucketName,
    lifecycleConfiguration: Optional[
      zio.aws.s3control.model.LifecycleConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationRequest = {
    import PutBucketLifecycleConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        lifecycleConfiguration.map(value => value.buildAwsValue())
      )(_.lifecycleConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.PutBucketLifecycleConfigurationRequest.ReadOnly =
    zio.aws.s3control.model.PutBucketLifecycleConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketLifecycleConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.PutBucketLifecycleConfigurationRequest =
      zio.aws.s3control.model.PutBucketLifecycleConfigurationRequest(
        accountId,
        bucket,
        lifecycleConfiguration.map(value => value.asEditable)
      )
    def accountId: AccountId
    def bucket: BucketName
    def lifecycleConfiguration
        : Optional[zio.aws.s3control.model.LifecycleConfiguration.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getLifecycleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.LifecycleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lifecycleConfiguration",
      lifecycleConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationRequest
  ) extends zio.aws.s3control.model.PutBucketLifecycleConfigurationRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val lifecycleConfiguration
        : Optional[zio.aws.s3control.model.LifecycleConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleConfiguration())
        .map(value =>
          zio.aws.s3control.model.LifecycleConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationRequest
  ): zio.aws.s3control.model.PutBucketLifecycleConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
