package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait ObjectLambdaTransformationConfigurationAction {
  def unwrap: software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction
}
object ObjectLambdaTransformationConfigurationAction {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction
  ): zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction =
    value match {
      case software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction.GET_OBJECT =>
        val r = GetObject
        r
      case software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction.HEAD_OBJECT =>
        val r = HeadObject
        r
      case software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction.LIST_OBJECTS =>
        val r = ListObjects
        r
      case software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction.LIST_OBJECTS_V2 =>
        val r = ListObjectsV2
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction =
      software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction.UNKNOWN_TO_SDK_VERSION
  }
  case object GetObject
      extends zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction =
      software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction.GET_OBJECT
  }
  case object HeadObject
      extends zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction =
      software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction.HEAD_OBJECT
  }
  case object ListObjects
      extends zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction =
      software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction.LIST_OBJECTS
  }
  case object ListObjectsV2
      extends zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction =
      software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction.LIST_OBJECTS_V2
  }
}
