package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.ObjectLambdaAccessPointAliasValue
import scala.jdk.CollectionConverters.*
final case class ObjectLambdaAccessPointAlias(
    value: Optional[ObjectLambdaAccessPointAliasValue] = Optional.Absent,
    status: Optional[
      zio.aws.s3control.model.ObjectLambdaAccessPointAliasStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAlias = {
    import ObjectLambdaAccessPointAlias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAlias
      .builder()
      .optionallyWith(
        value.map(value =>
          ObjectLambdaAccessPointAliasValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly =
    zio.aws.s3control.model.ObjectLambdaAccessPointAlias.wrap(buildAwsValue())
}
object ObjectLambdaAccessPointAlias {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAlias
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ObjectLambdaAccessPointAlias =
      zio.aws.s3control.model.ObjectLambdaAccessPointAlias(
        value.map(value => value),
        status.map(value => value)
      )
    def value: Optional[ObjectLambdaAccessPointAliasValue]
    def status
        : Optional[zio.aws.s3control.model.ObjectLambdaAccessPointAliasStatus]
    def getValue: ZIO[Any, AwsError, ObjectLambdaAccessPointAliasValue] =
      AwsError.unwrapOptionField("value", value)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ObjectLambdaAccessPointAliasStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAlias
  ) extends zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly {
    override val value: Optional[ObjectLambdaAccessPointAliasValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.s3control.model.primitives
            .ObjectLambdaAccessPointAliasValue(value)
        )
    override val status
        : Optional[zio.aws.s3control.model.ObjectLambdaAccessPointAliasStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.s3control.model.ObjectLambdaAccessPointAliasStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAlias
  ): zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly =
    new Wrapper(impl)
}
