package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{
  ObjectLambdaAccessPointArn,
  ObjectLambdaAccessPointName
}
import scala.jdk.CollectionConverters.*
final case class ObjectLambdaAccessPoint(
    name: ObjectLambdaAccessPointName,
    objectLambdaAccessPointArn: Optional[ObjectLambdaAccessPointArn] =
      Optional.Absent,
    alias: Optional[zio.aws.s3control.model.ObjectLambdaAccessPointAlias] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint = {
    import ObjectLambdaAccessPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint
      .builder()
      .name(ObjectLambdaAccessPointName.unwrap(name): java.lang.String)
      .optionallyWith(
        objectLambdaAccessPointArn.map(value =>
          ObjectLambdaAccessPointArn.unwrap(value): java.lang.String
        )
      )(_.objectLambdaAccessPointArn)
      .optionallyWith(alias.map(value => value.buildAwsValue()))(_.alias)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly =
    zio.aws.s3control.model.ObjectLambdaAccessPoint.wrap(buildAwsValue())
}
object ObjectLambdaAccessPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ObjectLambdaAccessPoint =
      zio.aws.s3control.model.ObjectLambdaAccessPoint(
        name,
        objectLambdaAccessPointArn.map(value => value),
        alias.map(value => value.asEditable)
      )
    def name: ObjectLambdaAccessPointName
    def objectLambdaAccessPointArn: Optional[ObjectLambdaAccessPointArn]
    def alias: Optional[
      zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly
    ]
    def getName: ZIO[Any, Nothing, ObjectLambdaAccessPointName] =
      ZIO.succeed(name)
    def getObjectLambdaAccessPointArn
        : ZIO[Any, AwsError, ObjectLambdaAccessPointArn] =
      AwsError.unwrapOptionField(
        "objectLambdaAccessPointArn",
        objectLambdaAccessPointArn
      )
    def getAlias: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly
    ] = AwsError.unwrapOptionField("alias", alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint
  ) extends zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly {
    override val name: ObjectLambdaAccessPointName =
      zio.aws.s3control.model.primitives
        .ObjectLambdaAccessPointName(impl.name())
    override val objectLambdaAccessPointArn
        : Optional[ObjectLambdaAccessPointArn] = zio.aws.core.internal
      .optionalFromNullable(impl.objectLambdaAccessPointArn())
      .map(value =>
        zio.aws.s3control.model.primitives.ObjectLambdaAccessPointArn(value)
      )
    override val alias: Optional[
      zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value =>
        zio.aws.s3control.model.ObjectLambdaAccessPointAlias.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint
  ): zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly = new Wrapper(
    impl
  )
}
