package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{NoncurrentVersionCount, Days}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class NoncurrentVersionExpiration(
    noncurrentDays: Optional[Days] = Optional.Absent,
    newerNoncurrentVersions: Optional[NoncurrentVersionCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration = {
    import NoncurrentVersionExpiration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
      .builder()
      .optionallyWith(noncurrentDays.map(value => Days.unwrap(value): Integer))(
        _.noncurrentDays
      )
      .optionallyWith(
        newerNoncurrentVersions.map(value =>
          NoncurrentVersionCount.unwrap(value): Integer
        )
      )(_.newerNoncurrentVersions)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly =
    zio.aws.s3control.model.NoncurrentVersionExpiration.wrap(buildAwsValue())
}
object NoncurrentVersionExpiration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.NoncurrentVersionExpiration =
      zio.aws.s3control.model.NoncurrentVersionExpiration(
        noncurrentDays.map(value => value),
        newerNoncurrentVersions.map(value => value)
      )
    def noncurrentDays: Optional[Days]
    def newerNoncurrentVersions: Optional[NoncurrentVersionCount]
    def getNoncurrentDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("noncurrentDays", noncurrentDays)
    def getNewerNoncurrentVersions: ZIO[Any, AwsError, NoncurrentVersionCount] =
      AwsError.unwrapOptionField(
        "newerNoncurrentVersions",
        newerNoncurrentVersions
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
  ) extends zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly {
    override val noncurrentDays: Optional[Days] = zio.aws.core.internal
      .optionalFromNullable(impl.noncurrentDays())
      .map(value => zio.aws.s3control.model.primitives.Days(value))
    override val newerNoncurrentVersions: Optional[NoncurrentVersionCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newerNoncurrentVersions())
        .map(value =>
          zio.aws.s3control.model.primitives.NoncurrentVersionCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.NoncurrentVersionExpiration
  ): zio.aws.s3control.model.NoncurrentVersionExpiration.ReadOnly = new Wrapper(
    impl
  )
}
