package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  TrafficDialPercentage,
  RegionName,
  BucketName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class MultiRegionAccessPointRoute(
    bucket: Optional[BucketName] = Optional.Absent,
    region: Optional[RegionName] = Optional.Absent,
    trafficDialPercentage: TrafficDialPercentage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute = {
    import MultiRegionAccessPointRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute
      .builder()
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        region.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.region)
      .trafficDialPercentage(
        TrafficDialPercentage.unwrap(trafficDialPercentage): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.MultiRegionAccessPointRoute.ReadOnly =
    zio.aws.s3control.model.MultiRegionAccessPointRoute.wrap(buildAwsValue())
}
object MultiRegionAccessPointRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.MultiRegionAccessPointRoute =
      zio.aws.s3control.model.MultiRegionAccessPointRoute(
        bucket.map(value => value),
        region.map(value => value),
        trafficDialPercentage
      )
    def bucket: Optional[BucketName]
    def region: Optional[RegionName]
    def trafficDialPercentage: TrafficDialPercentage
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getRegion: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("region", region)
    def getTrafficDialPercentage: ZIO[Any, Nothing, TrafficDialPercentage] =
      ZIO.succeed(trafficDialPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute
  ) extends zio.aws.s3control.model.MultiRegionAccessPointRoute.ReadOnly {
    override val bucket: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.s3control.model.primitives.BucketName(value))
    override val region: Optional[RegionName] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.s3control.model.primitives.RegionName(value))
    override val trafficDialPercentage: TrafficDialPercentage =
      zio.aws.s3control.model.primitives
        .TrafficDialPercentage(impl.trafficDialPercentage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute
  ): zio.aws.s3control.model.MultiRegionAccessPointRoute.ReadOnly = new Wrapper(
    impl
  )
}
