package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{
  ObjectSizeLessThanBytes,
  ObjectSizeGreaterThanBytes,
  Prefix
}
import scala.jdk.CollectionConverters.*
final case class LifecycleRuleFilter(
    prefix: Optional[Prefix] = Optional.Absent,
    tag: Optional[zio.aws.s3control.model.S3Tag] = Optional.Absent,
    and: Optional[zio.aws.s3control.model.LifecycleRuleAndOperator] =
      Optional.Absent,
    objectSizeGreaterThan: Optional[ObjectSizeGreaterThanBytes] =
      Optional.Absent,
    objectSizeLessThan: Optional[ObjectSizeLessThanBytes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.LifecycleRuleFilter = {
    import LifecycleRuleFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.LifecycleRuleFilter
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .optionallyWith(
        objectSizeGreaterThan.map(value =>
          ObjectSizeGreaterThanBytes.unwrap(value): java.lang.Long
        )
      )(_.objectSizeGreaterThan)
      .optionallyWith(
        objectSizeLessThan.map(value =>
          ObjectSizeLessThanBytes.unwrap(value): java.lang.Long
        )
      )(_.objectSizeLessThan)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.LifecycleRuleFilter.ReadOnly =
    zio.aws.s3control.model.LifecycleRuleFilter.wrap(buildAwsValue())
}
object LifecycleRuleFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.LifecycleRuleFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.LifecycleRuleFilter =
      zio.aws.s3control.model.LifecycleRuleFilter(
        prefix.map(value => value),
        tag.map(value => value.asEditable),
        and.map(value => value.asEditable),
        objectSizeGreaterThan.map(value => value),
        objectSizeLessThan.map(value => value)
      )
    def prefix: Optional[Prefix]
    def tag: Optional[zio.aws.s3control.model.S3Tag.ReadOnly]
    def and: Optional[zio.aws.s3control.model.LifecycleRuleAndOperator.ReadOnly]
    def objectSizeGreaterThan: Optional[ObjectSizeGreaterThanBytes]
    def objectSizeLessThan: Optional[ObjectSizeLessThanBytes]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTag: ZIO[Any, AwsError, zio.aws.s3control.model.S3Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tag)
    def getAnd: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.LifecycleRuleAndOperator.ReadOnly
    ] = AwsError.unwrapOptionField("and", and)
    def getObjectSizeGreaterThan
        : ZIO[Any, AwsError, ObjectSizeGreaterThanBytes] =
      AwsError.unwrapOptionField("objectSizeGreaterThan", objectSizeGreaterThan)
    def getObjectSizeLessThan: ZIO[Any, AwsError, ObjectSizeLessThanBytes] =
      AwsError.unwrapOptionField("objectSizeLessThan", objectSizeLessThan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleRuleFilter
  ) extends zio.aws.s3control.model.LifecycleRuleFilter.ReadOnly {
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3control.model.primitives.Prefix(value))
    override val tag: Optional[zio.aws.s3control.model.S3Tag.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tag())
        .map(value => zio.aws.s3control.model.S3Tag.wrap(value))
    override val and
        : Optional[zio.aws.s3control.model.LifecycleRuleAndOperator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.and())
        .map(value =>
          zio.aws.s3control.model.LifecycleRuleAndOperator.wrap(value)
        )
    override val objectSizeGreaterThan: Optional[ObjectSizeGreaterThanBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectSizeGreaterThan())
        .map(value =>
          zio.aws.s3control.model.primitives.ObjectSizeGreaterThanBytes(value)
        )
    override val objectSizeLessThan: Optional[ObjectSizeLessThanBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectSizeLessThan())
        .map(value =>
          zio.aws.s3control.model.primitives.ObjectSizeLessThanBytes(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleRuleFilter
  ): zio.aws.s3control.model.LifecycleRuleFilter.ReadOnly = new Wrapper(impl)
}
