package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.FunctionArnString
import scala.jdk.CollectionConverters.*
final case class LambdaInvokeOperation(
    functionArn: Optional[FunctionArnString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.LambdaInvokeOperation = {
    import LambdaInvokeOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.LambdaInvokeOperation
      .builder()
      .optionallyWith(
        functionArn.map(value =>
          FunctionArnString.unwrap(value): java.lang.String
        )
      )(_.functionArn)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.LambdaInvokeOperation.ReadOnly =
    zio.aws.s3control.model.LambdaInvokeOperation.wrap(buildAwsValue())
}
object LambdaInvokeOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.LambdaInvokeOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.LambdaInvokeOperation =
      zio.aws.s3control.model
        .LambdaInvokeOperation(functionArn.map(value => value))
    def functionArn: Optional[FunctionArnString]
    def getFunctionArn: ZIO[Any, AwsError, FunctionArnString] =
      AwsError.unwrapOptionField("functionArn", functionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.LambdaInvokeOperation
  ) extends zio.aws.s3control.model.LambdaInvokeOperation.ReadOnly {
    override val functionArn: Optional[FunctionArnString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionArn())
        .map(value =>
          zio.aws.s3control.model.primitives.FunctionArnString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.LambdaInvokeOperation
  ): zio.aws.s3control.model.LambdaInvokeOperation.ReadOnly = new Wrapper(impl)
}
