package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{MultiRegionAccessPointId, AccountId}
import scala.jdk.CollectionConverters.*
final case class GetMultiRegionAccessPointRoutesRequest(
    accountId: AccountId,
    mrap: MultiRegionAccessPointId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesRequest = {
    import GetMultiRegionAccessPointRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .mrap(MultiRegionAccessPointId.unwrap(mrap): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetMultiRegionAccessPointRoutesRequest.ReadOnly =
    zio.aws.s3control.model.GetMultiRegionAccessPointRoutesRequest
      .wrap(buildAwsValue())
}
object GetMultiRegionAccessPointRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetMultiRegionAccessPointRoutesRequest =
      zio.aws.s3control.model
        .GetMultiRegionAccessPointRoutesRequest(accountId, mrap)
    def accountId: AccountId
    def mrap: MultiRegionAccessPointId
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getMrap: ZIO[Any, Nothing, MultiRegionAccessPointId] = ZIO.succeed(mrap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesRequest
  ) extends zio.aws.s3control.model.GetMultiRegionAccessPointRoutesRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val mrap: MultiRegionAccessPointId =
      zio.aws.s3control.model.primitives.MultiRegionAccessPointId(impl.mrap())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesRequest
  ): zio.aws.s3control.model.GetMultiRegionAccessPointRoutesRequest.ReadOnly =
    new Wrapper(impl)
}
