package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetBucketReplicationResponse(
    replicationConfiguration: Optional[
      zio.aws.s3control.model.ReplicationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetBucketReplicationResponse = {
    import GetBucketReplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetBucketReplicationResponse
      .builder()
      .optionallyWith(
        replicationConfiguration.map(value => value.buildAwsValue())
      )(_.replicationConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetBucketReplicationResponse.ReadOnly =
    zio.aws.s3control.model.GetBucketReplicationResponse.wrap(buildAwsValue())
}
object GetBucketReplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetBucketReplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetBucketReplicationResponse =
      zio.aws.s3control.model.GetBucketReplicationResponse(
        replicationConfiguration.map(value => value.asEditable)
      )
    def replicationConfiguration
        : Optional[zio.aws.s3control.model.ReplicationConfiguration.ReadOnly]
    def getReplicationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ReplicationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationConfiguration",
      replicationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketReplicationResponse
  ) extends zio.aws.s3control.model.GetBucketReplicationResponse.ReadOnly {
    override val replicationConfiguration
        : Optional[zio.aws.s3control.model.ReplicationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfiguration())
        .map(value =>
          zio.aws.s3control.model.ReplicationConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketReplicationResponse
  ): zio.aws.s3control.model.GetBucketReplicationResponse.ReadOnly =
    new Wrapper(impl)
}
