package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  NonEmptyMaxLength64String,
  AccessPointName,
  AccountId,
  NonEmptyMaxLength1024String,
  BucketName,
  Alias,
  S3AccessPointArn,
  CreationDate
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetAccessPointResponse(
    name: Optional[AccessPointName] = Optional.Absent,
    bucket: Optional[BucketName] = Optional.Absent,
    networkOrigin: Optional[zio.aws.s3control.model.NetworkOrigin] =
      Optional.Absent,
    vpcConfiguration: Optional[zio.aws.s3control.model.VpcConfiguration] =
      Optional.Absent,
    publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration
    ] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent,
    alias: Optional[Alias] = Optional.Absent,
    accessPointArn: Optional[S3AccessPointArn] = Optional.Absent,
    endpoints: Optional[
      Map[NonEmptyMaxLength64String, NonEmptyMaxLength1024String]
    ] = Optional.Absent,
    bucketAccountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetAccessPointResponse = {
    import GetAccessPointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetAccessPointResponse
      .builder()
      .optionallyWith(
        name.map(value => AccessPointName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(networkOrigin.map(value => value.unwrap))(_.networkOrigin)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        publicAccessBlockConfiguration.map(value => value.buildAwsValue())
      )(_.publicAccessBlockConfiguration)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        alias.map(value => Alias.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(
        accessPointArn.map(value =>
          S3AccessPointArn.unwrap(value): java.lang.String
        )
      )(_.accessPointArn)
      .optionallyWith(
        endpoints.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyMaxLength64String
                .unwrap(key): java.lang.String) -> (NonEmptyMaxLength1024String
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.endpoints)
      .optionallyWith(
        bucketAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.bucketAccountId)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GetAccessPointResponse.ReadOnly =
    zio.aws.s3control.model.GetAccessPointResponse.wrap(buildAwsValue())
}
object GetAccessPointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetAccessPointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetAccessPointResponse =
      zio.aws.s3control.model.GetAccessPointResponse(
        name.map(value => value),
        bucket.map(value => value),
        networkOrigin.map(value => value),
        vpcConfiguration.map(value => value.asEditable),
        publicAccessBlockConfiguration.map(value => value.asEditable),
        creationDate.map(value => value),
        alias.map(value => value),
        accessPointArn.map(value => value),
        endpoints.map(value => value),
        bucketAccountId.map(value => value)
      )
    def name: Optional[AccessPointName]
    def bucket: Optional[BucketName]
    def networkOrigin: Optional[zio.aws.s3control.model.NetworkOrigin]
    def vpcConfiguration
        : Optional[zio.aws.s3control.model.VpcConfiguration.ReadOnly]
    def publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ]
    def creationDate: Optional[CreationDate]
    def alias: Optional[Alias]
    def accessPointArn: Optional[S3AccessPointArn]
    def endpoints
        : Optional[Map[NonEmptyMaxLength64String, NonEmptyMaxLength1024String]]
    def bucketAccountId: Optional[AccountId]
    def getName: ZIO[Any, AwsError, AccessPointName] =
      AwsError.unwrapOptionField("name", name)
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getNetworkOrigin
        : ZIO[Any, AwsError, zio.aws.s3control.model.NetworkOrigin] =
      AwsError.unwrapOptionField("networkOrigin", networkOrigin)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getPublicAccessBlockConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicAccessBlockConfiguration",
      publicAccessBlockConfiguration
    )
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getAlias: ZIO[Any, AwsError, Alias] =
      AwsError.unwrapOptionField("alias", alias)
    def getAccessPointArn: ZIO[Any, AwsError, S3AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
    def getEndpoints: ZIO[Any, AwsError, Map[
      NonEmptyMaxLength64String,
      NonEmptyMaxLength1024String
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
    def getBucketAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("bucketAccountId", bucketAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointResponse
  ) extends zio.aws.s3control.model.GetAccessPointResponse.ReadOnly {
    override val name: Optional[AccessPointName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.s3control.model.primitives.AccessPointName(value))
    override val bucket: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.s3control.model.primitives.BucketName(value))
    override val networkOrigin
        : Optional[zio.aws.s3control.model.NetworkOrigin] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkOrigin())
        .map(value => zio.aws.s3control.model.NetworkOrigin.wrap(value))
    override val vpcConfiguration
        : Optional[zio.aws.s3control.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.s3control.model.VpcConfiguration.wrap(value))
    override val publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.publicAccessBlockConfiguration())
      .map(value =>
        zio.aws.s3control.model.PublicAccessBlockConfiguration.wrap(value)
      )
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.s3control.model.primitives.CreationDate(value))
    override val alias: Optional[Alias] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value => zio.aws.s3control.model.primitives.Alias(value))
    override val accessPointArn: Optional[S3AccessPointArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPointArn())
        .map(value =>
          zio.aws.s3control.model.primitives.S3AccessPointArn(value)
        )
    override val endpoints: Optional[
      Map[NonEmptyMaxLength64String, NonEmptyMaxLength1024String]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoints())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.s3control.model.primitives.NonEmptyMaxLength64String(
              key
            ) -> zio.aws.s3control.model.primitives
              .NonEmptyMaxLength1024String(value)
          })
          .toMap
      )
    override val bucketAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketAccountId())
      .map(value => zio.aws.s3control.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointResponse
  ): zio.aws.s3control.model.GetAccessPointResponse.ReadOnly = new Wrapper(impl)
}
