package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait GeneratedManifestFormat {
  def unwrap
      : software.amazon.awssdk.services.s3control.model.GeneratedManifestFormat
}
object GeneratedManifestFormat {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.GeneratedManifestFormat
  ): zio.aws.s3control.model.GeneratedManifestFormat = value match {
    case software.amazon.awssdk.services.s3control.model.GeneratedManifestFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.GeneratedManifestFormat.S3_INVENTORY_REPORT_CSV_20211130 =>
      val r = S3InventoryReport_CSV_20211130
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.GeneratedManifestFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.GeneratedManifestFormat =
      software.amazon.awssdk.services.s3control.model.GeneratedManifestFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object S3InventoryReport_CSV_20211130
      extends zio.aws.s3control.model.GeneratedManifestFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.GeneratedManifestFormat =
      software.amazon.awssdk.services.s3control.model.GeneratedManifestFormat.S3_INVENTORY_REPORT_CSV_20211130
  }
}
