package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMarkerReplication(
    status: zio.aws.s3control.model.DeleteMarkerReplicationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DeleteMarkerReplication = {
    import DeleteMarkerReplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DeleteMarkerReplication
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.DeleteMarkerReplication.ReadOnly =
    zio.aws.s3control.model.DeleteMarkerReplication.wrap(buildAwsValue())
}
object DeleteMarkerReplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DeleteMarkerReplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.DeleteMarkerReplication =
      zio.aws.s3control.model.DeleteMarkerReplication(status)
    def status: zio.aws.s3control.model.DeleteMarkerReplicationStatus
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.DeleteMarkerReplicationStatus
    ] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DeleteMarkerReplication
  ) extends zio.aws.s3control.model.DeleteMarkerReplication.ReadOnly {
    override val status: zio.aws.s3control.model.DeleteMarkerReplicationStatus =
      zio.aws.s3control.model.DeleteMarkerReplicationStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DeleteMarkerReplication
  ): zio.aws.s3control.model.DeleteMarkerReplication.ReadOnly = new Wrapper(
    impl
  )
}
