package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.ObjectLambdaAccessPointArn
import scala.jdk.CollectionConverters.*
final case class CreateAccessPointForObjectLambdaResponse(
    objectLambdaAccessPointArn: Optional[ObjectLambdaAccessPointArn] =
      Optional.Absent,
    alias: Optional[zio.aws.s3control.model.ObjectLambdaAccessPointAlias] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse = {
    import CreateAccessPointForObjectLambdaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse
      .builder()
      .optionallyWith(
        objectLambdaAccessPointArn.map(value =>
          ObjectLambdaAccessPointArn.unwrap(value): java.lang.String
        )
      )(_.objectLambdaAccessPointArn)
      .optionallyWith(alias.map(value => value.buildAwsValue()))(_.alias)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.ReadOnly =
    zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse
      .wrap(buildAwsValue())
}
object CreateAccessPointForObjectLambdaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse =
      zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse(
        objectLambdaAccessPointArn.map(value => value),
        alias.map(value => value.asEditable)
      )
    def objectLambdaAccessPointArn: Optional[ObjectLambdaAccessPointArn]
    def alias: Optional[
      zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly
    ]
    def getObjectLambdaAccessPointArn
        : ZIO[Any, AwsError, ObjectLambdaAccessPointArn] =
      AwsError.unwrapOptionField(
        "objectLambdaAccessPointArn",
        objectLambdaAccessPointArn
      )
    def getAlias: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly
    ] = AwsError.unwrapOptionField("alias", alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse
  ) extends zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.ReadOnly {
    override val objectLambdaAccessPointArn
        : Optional[ObjectLambdaAccessPointArn] = zio.aws.core.internal
      .optionalFromNullable(impl.objectLambdaAccessPointArn())
      .map(value =>
        zio.aws.s3control.model.primitives.ObjectLambdaAccessPointArn(value)
      )
    override val alias: Optional[
      zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value =>
        zio.aws.s3control.model.ObjectLambdaAccessPointAlias.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse
  ): zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.ReadOnly =
    new Wrapper(impl)
}
