package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  AsyncRequestStatus,
  AsyncRequestTokenARN,
  AsyncCreationTimestamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AsyncOperation(
    creationTime: Optional[AsyncCreationTimestamp] = Optional.Absent,
    operation: Optional[zio.aws.s3control.model.AsyncOperationName] =
      Optional.Absent,
    requestTokenARN: Optional[AsyncRequestTokenARN] = Optional.Absent,
    requestParameters: Optional[
      zio.aws.s3control.model.AsyncRequestParameters
    ] = Optional.Absent,
    requestStatus: Optional[AsyncRequestStatus] = Optional.Absent,
    responseDetails: Optional[zio.aws.s3control.model.AsyncResponseDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AsyncOperation = {
    import AsyncOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AsyncOperation
      .builder()
      .optionallyWith(
        creationTime.map(value => AsyncCreationTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(operation.map(value => value.unwrap))(_.operation)
      .optionallyWith(
        requestTokenARN.map(value =>
          AsyncRequestTokenARN.unwrap(value): java.lang.String
        )
      )(_.requestTokenARN)
      .optionallyWith(requestParameters.map(value => value.buildAwsValue()))(
        _.requestParameters
      )
      .optionallyWith(
        requestStatus.map(value =>
          AsyncRequestStatus.unwrap(value): java.lang.String
        )
      )(_.requestStatus)
      .optionallyWith(responseDetails.map(value => value.buildAwsValue()))(
        _.responseDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AsyncOperation.ReadOnly =
    zio.aws.s3control.model.AsyncOperation.wrap(buildAwsValue())
}
object AsyncOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AsyncOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AsyncOperation =
      zio.aws.s3control.model.AsyncOperation(
        creationTime.map(value => value),
        operation.map(value => value),
        requestTokenARN.map(value => value),
        requestParameters.map(value => value.asEditable),
        requestStatus.map(value => value),
        responseDetails.map(value => value.asEditable)
      )
    def creationTime: Optional[AsyncCreationTimestamp]
    def operation: Optional[zio.aws.s3control.model.AsyncOperationName]
    def requestTokenARN: Optional[AsyncRequestTokenARN]
    def requestParameters
        : Optional[zio.aws.s3control.model.AsyncRequestParameters.ReadOnly]
    def requestStatus: Optional[AsyncRequestStatus]
    def responseDetails
        : Optional[zio.aws.s3control.model.AsyncResponseDetails.ReadOnly]
    def getCreationTime: ZIO[Any, AwsError, AsyncCreationTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getOperation
        : ZIO[Any, AwsError, zio.aws.s3control.model.AsyncOperationName] =
      AwsError.unwrapOptionField("operation", operation)
    def getRequestTokenARN: ZIO[Any, AwsError, AsyncRequestTokenARN] =
      AwsError.unwrapOptionField("requestTokenARN", requestTokenARN)
    def getRequestParameters: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AsyncRequestParameters.ReadOnly
    ] = AwsError.unwrapOptionField("requestParameters", requestParameters)
    def getRequestStatus: ZIO[Any, AwsError, AsyncRequestStatus] =
      AwsError.unwrapOptionField("requestStatus", requestStatus)
    def getResponseDetails: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AsyncResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField("responseDetails", responseDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AsyncOperation
  ) extends zio.aws.s3control.model.AsyncOperation.ReadOnly {
    override val creationTime: Optional[AsyncCreationTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value =>
          zio.aws.s3control.model.primitives.AsyncCreationTimestamp(value)
        )
    override val operation
        : Optional[zio.aws.s3control.model.AsyncOperationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value => zio.aws.s3control.model.AsyncOperationName.wrap(value))
    override val requestTokenARN: Optional[AsyncRequestTokenARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestTokenARN())
        .map(value =>
          zio.aws.s3control.model.primitives.AsyncRequestTokenARN(value)
        )
    override val requestParameters
        : Optional[zio.aws.s3control.model.AsyncRequestParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestParameters())
        .map(value =>
          zio.aws.s3control.model.AsyncRequestParameters.wrap(value)
        )
    override val requestStatus: Optional[AsyncRequestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestStatus())
        .map(value =>
          zio.aws.s3control.model.primitives.AsyncRequestStatus(value)
        )
    override val responseDetails
        : Optional[zio.aws.s3control.model.AsyncResponseDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseDetails())
        .map(value => zio.aws.s3control.model.AsyncResponseDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AsyncOperation
  ): zio.aws.s3control.model.AsyncOperation.ReadOnly = new Wrapper(impl)
}
