package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.IsEnabled
import scala.jdk.CollectionConverters.*
final case class AdvancedDataProtectionMetrics(
    isEnabled: Optional[IsEnabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AdvancedDataProtectionMetrics = {
    import AdvancedDataProtectionMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AdvancedDataProtectionMetrics
      .builder()
      .optionallyWith(
        isEnabled.map(value => IsEnabled.unwrap(value): java.lang.Boolean)
      )(_.isEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.AdvancedDataProtectionMetrics.ReadOnly =
    zio.aws.s3control.model.AdvancedDataProtectionMetrics.wrap(buildAwsValue())
}
object AdvancedDataProtectionMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AdvancedDataProtectionMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AdvancedDataProtectionMetrics =
      zio.aws.s3control.model
        .AdvancedDataProtectionMetrics(isEnabled.map(value => value))
    def isEnabled: Optional[IsEnabled]
    def getIsEnabled: ZIO[Any, AwsError, IsEnabled] =
      AwsError.unwrapOptionField("isEnabled", isEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AdvancedDataProtectionMetrics
  ) extends zio.aws.s3control.model.AdvancedDataProtectionMetrics.ReadOnly {
    override val isEnabled: Optional[IsEnabled] = zio.aws.core.internal
      .optionalFromNullable(impl.isEnabled())
      .map(value => zio.aws.s3control.model.primitives.IsEnabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AdvancedDataProtectionMetrics
  ): zio.aws.s3control.model.AdvancedDataProtectionMetrics.ReadOnly =
    new Wrapper(impl)
}
