package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{
  AccessPointName,
  AccountId,
  BucketName,
  Alias,
  S3AccessPointArn
}
import scala.jdk.CollectionConverters.*
final case class AccessPoint(
    name: AccessPointName,
    networkOrigin: zio.aws.s3control.model.NetworkOrigin,
    vpcConfiguration: Optional[zio.aws.s3control.model.VpcConfiguration] =
      Optional.Absent,
    bucket: BucketName,
    accessPointArn: Optional[S3AccessPointArn] = Optional.Absent,
    alias: Optional[Alias] = Optional.Absent,
    bucketAccountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AccessPoint = {
    import AccessPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AccessPoint
      .builder()
      .name(AccessPointName.unwrap(name): java.lang.String)
      .networkOrigin(networkOrigin.unwrap)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        accessPointArn.map(value =>
          S3AccessPointArn.unwrap(value): java.lang.String
        )
      )(_.accessPointArn)
      .optionallyWith(
        alias.map(value => Alias.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(
        bucketAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.bucketAccountId)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AccessPoint.ReadOnly =
    zio.aws.s3control.model.AccessPoint.wrap(buildAwsValue())
}
object AccessPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AccessPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AccessPoint =
      zio.aws.s3control.model.AccessPoint(
        name,
        networkOrigin,
        vpcConfiguration.map(value => value.asEditable),
        bucket,
        accessPointArn.map(value => value),
        alias.map(value => value),
        bucketAccountId.map(value => value)
      )
    def name: AccessPointName
    def networkOrigin: zio.aws.s3control.model.NetworkOrigin
    def vpcConfiguration
        : Optional[zio.aws.s3control.model.VpcConfiguration.ReadOnly]
    def bucket: BucketName
    def accessPointArn: Optional[S3AccessPointArn]
    def alias: Optional[Alias]
    def bucketAccountId: Optional[AccountId]
    def getName: ZIO[Any, Nothing, AccessPointName] = ZIO.succeed(name)
    def getNetworkOrigin
        : ZIO[Any, Nothing, zio.aws.s3control.model.NetworkOrigin] =
      ZIO.succeed(networkOrigin)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getAccessPointArn: ZIO[Any, AwsError, S3AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
    def getAlias: ZIO[Any, AwsError, Alias] =
      AwsError.unwrapOptionField("alias", alias)
    def getBucketAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("bucketAccountId", bucketAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AccessPoint
  ) extends zio.aws.s3control.model.AccessPoint.ReadOnly {
    override val name: AccessPointName =
      zio.aws.s3control.model.primitives.AccessPointName(impl.name())
    override val networkOrigin: zio.aws.s3control.model.NetworkOrigin =
      zio.aws.s3control.model.NetworkOrigin.wrap(impl.networkOrigin())
    override val vpcConfiguration
        : Optional[zio.aws.s3control.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.s3control.model.VpcConfiguration.wrap(value))
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val accessPointArn: Optional[S3AccessPointArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPointArn())
        .map(value =>
          zio.aws.s3control.model.primitives.S3AccessPointArn(value)
        )
    override val alias: Optional[Alias] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value => zio.aws.s3control.model.primitives.Alias(value))
    override val bucketAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketAccountId())
      .map(value => zio.aws.s3control.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AccessPoint
  ): zio.aws.s3control.model.AccessPoint.ReadOnly = new Wrapper(impl)
}
