package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AccessControlTranslation(
    owner: zio.aws.s3control.model.OwnerOverride
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AccessControlTranslation = {
    import AccessControlTranslation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AccessControlTranslation
      .builder()
      .owner(owner.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AccessControlTranslation.ReadOnly =
    zio.aws.s3control.model.AccessControlTranslation.wrap(buildAwsValue())
}
object AccessControlTranslation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AccessControlTranslation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AccessControlTranslation =
      zio.aws.s3control.model.AccessControlTranslation(owner)
    def owner: zio.aws.s3control.model.OwnerOverride
    def getOwner: ZIO[Any, Nothing, zio.aws.s3control.model.OwnerOverride] =
      ZIO.succeed(owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AccessControlTranslation
  ) extends zio.aws.s3control.model.AccessControlTranslation.ReadOnly {
    override val owner: zio.aws.s3control.model.OwnerOverride =
      zio.aws.s3control.model.OwnerOverride.wrap(impl.owner())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AccessControlTranslation
  ): zio.aws.s3control.model.AccessControlTranslation.ReadOnly = new Wrapper(
    impl
  )
}
