package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.KmsKeyArnString
import scala.jdk.CollectionConverters.*
final case class SSEKMSEncryption(keyId: KmsKeyArnString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.SSEKMSEncryption = {
    import SSEKMSEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.SSEKMSEncryption
      .builder()
      .keyId(KmsKeyArnString.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.SSEKMSEncryption.ReadOnly =
    zio.aws.s3control.model.SSEKMSEncryption.wrap(buildAwsValue())
}
object SSEKMSEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.SSEKMSEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.SSEKMSEncryption =
      zio.aws.s3control.model.SSEKMSEncryption(keyId)
    def keyId: KmsKeyArnString
    def getKeyId: ZIO[Any, Nothing, KmsKeyArnString] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.SSEKMSEncryption
  ) extends zio.aws.s3control.model.SSEKMSEncryption.ReadOnly {
    override val keyId: KmsKeyArnString =
      zio.aws.s3control.model.primitives.KmsKeyArnString(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.SSEKMSEncryption
  ): zio.aws.s3control.model.SSEKMSEncryption.ReadOnly = new Wrapper(impl)
}
