package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait S3ObjectLockRetentionMode {
  def unwrap: software.amazon.awssdk.services.s3control.model.S3ObjectLockRetentionMode
}
object S3ObjectLockRetentionMode {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.S3ObjectLockRetentionMode
  ): zio.aws.s3control.model.S3ObjectLockRetentionMode = value match {
    case software.amazon.awssdk.services.s3control.model.S3ObjectLockRetentionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.S3ObjectLockRetentionMode.COMPLIANCE =>
      val r = COMPLIANCE
      r
    case software.amazon.awssdk.services.s3control.model.S3ObjectLockRetentionMode.GOVERNANCE =>
      val r = GOVERNANCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.S3ObjectLockRetentionMode {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3ObjectLockRetentionMode =
      software.amazon.awssdk.services.s3control.model.S3ObjectLockRetentionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLIANCE
      extends zio.aws.s3control.model.S3ObjectLockRetentionMode {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3ObjectLockRetentionMode =
      software.amazon.awssdk.services.s3control.model.S3ObjectLockRetentionMode.COMPLIANCE
  }
  case object GOVERNANCE
      extends zio.aws.s3control.model.S3ObjectLockRetentionMode {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3ObjectLockRetentionMode =
      software.amazon.awssdk.services.s3control.model.S3ObjectLockRetentionMode.GOVERNANCE
  }
}
