package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{AccountId, ConfigId}
import scala.jdk.CollectionConverters.*
final case class PutStorageLensConfigurationTaggingRequest(
    configId: ConfigId,
    accountId: AccountId,
    tags: Iterable[zio.aws.s3control.model.StorageLensTag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingRequest = {
    import PutStorageLensConfigurationTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingRequest
      .builder()
      .configId(ConfigId.unwrap(configId): java.lang.String)
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.PutStorageLensConfigurationTaggingRequest.ReadOnly =
    zio.aws.s3control.model.PutStorageLensConfigurationTaggingRequest
      .wrap(buildAwsValue())
}
object PutStorageLensConfigurationTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.PutStorageLensConfigurationTaggingRequest =
      zio.aws.s3control.model.PutStorageLensConfigurationTaggingRequest(
        configId,
        accountId,
        tags.map { item =>
          item.asEditable
        }
      )
    def configId: ConfigId
    def accountId: AccountId
    def tags: List[zio.aws.s3control.model.StorageLensTag.ReadOnly]
    def getConfigId: ZIO[Any, Nothing, ConfigId] = ZIO.succeed(configId)
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.s3control.model.StorageLensTag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingRequest
  ) extends zio.aws.s3control.model.PutStorageLensConfigurationTaggingRequest.ReadOnly {
    override val configId: ConfigId =
      zio.aws.s3control.model.primitives.ConfigId(impl.configId())
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val tags: List[zio.aws.s3control.model.StorageLensTag.ReadOnly] =
      impl
        .tags()
        .asScala
        .map { item =>
          zio.aws.s3control.model.StorageLensTag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingRequest
  ): zio.aws.s3control.model.PutStorageLensConfigurationTaggingRequest.ReadOnly =
    new Wrapper(impl)
}
