package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{
  IsEnabled,
  S3AWSRegion,
  StorageLensArn,
  ConfigId
}
import scala.jdk.CollectionConverters.*
final case class ListStorageLensConfigurationEntry(
    id: ConfigId,
    storageLensArn: StorageLensArn,
    homeRegion: S3AWSRegion,
    isEnabled: Optional[IsEnabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationEntry = {
    import ListStorageLensConfigurationEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationEntry
      .builder()
      .id(ConfigId.unwrap(id): java.lang.String)
      .storageLensArn(StorageLensArn.unwrap(storageLensArn): java.lang.String)
      .homeRegion(S3AWSRegion.unwrap(homeRegion): java.lang.String)
      .optionallyWith(
        isEnabled.map(value => IsEnabled.unwrap(value): java.lang.Boolean)
      )(_.isEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly =
    zio.aws.s3control.model.ListStorageLensConfigurationEntry
      .wrap(buildAwsValue())
}
object ListStorageLensConfigurationEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ListStorageLensConfigurationEntry =
      zio.aws.s3control.model.ListStorageLensConfigurationEntry(
        id,
        storageLensArn,
        homeRegion,
        isEnabled.map(value => value)
      )
    def id: ConfigId
    def storageLensArn: StorageLensArn
    def homeRegion: S3AWSRegion
    def isEnabled: Optional[IsEnabled]
    def getId: ZIO[Any, Nothing, ConfigId] = ZIO.succeed(id)
    def getStorageLensArn: ZIO[Any, Nothing, StorageLensArn] =
      ZIO.succeed(storageLensArn)
    def getHomeRegion: ZIO[Any, Nothing, S3AWSRegion] = ZIO.succeed(homeRegion)
    def getIsEnabled: ZIO[Any, AwsError, IsEnabled] =
      AwsError.unwrapOptionField("isEnabled", isEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationEntry
  ) extends zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly {
    override val id: ConfigId =
      zio.aws.s3control.model.primitives.ConfigId(impl.id())
    override val storageLensArn: StorageLensArn =
      zio.aws.s3control.model.primitives.StorageLensArn(impl.storageLensArn())
    override val homeRegion: S3AWSRegion =
      zio.aws.s3control.model.primitives.S3AWSRegion(impl.homeRegion())
    override val isEnabled: Optional[IsEnabled] = zio.aws.core.internal
      .optionalFromNullable(impl.isEnabled())
      .map(value => zio.aws.s3control.model.primitives.IsEnabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationEntry
  ): zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly =
    new Wrapper(impl)
}
