package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{
  JobNumberOfTasksFailed,
  JobNumberOfTasksSucceeded,
  JobTotalNumberOfTasks
}
import scala.jdk.CollectionConverters.*
final case class JobProgressSummary(
    totalNumberOfTasks: Optional[JobTotalNumberOfTasks] = Optional.Absent,
    numberOfTasksSucceeded: Optional[JobNumberOfTasksSucceeded] =
      Optional.Absent,
    numberOfTasksFailed: Optional[JobNumberOfTasksFailed] = Optional.Absent,
    timers: Optional[zio.aws.s3control.model.JobTimers] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobProgressSummary = {
    import JobProgressSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobProgressSummary
      .builder()
      .optionallyWith(
        totalNumberOfTasks.map(value =>
          JobTotalNumberOfTasks.unwrap(value): java.lang.Long
        )
      )(_.totalNumberOfTasks)
      .optionallyWith(
        numberOfTasksSucceeded.map(value =>
          JobNumberOfTasksSucceeded.unwrap(value): java.lang.Long
        )
      )(_.numberOfTasksSucceeded)
      .optionallyWith(
        numberOfTasksFailed.map(value =>
          JobNumberOfTasksFailed.unwrap(value): java.lang.Long
        )
      )(_.numberOfTasksFailed)
      .optionallyWith(timers.map(value => value.buildAwsValue()))(_.timers)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobProgressSummary.ReadOnly =
    zio.aws.s3control.model.JobProgressSummary.wrap(buildAwsValue())
}
object JobProgressSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobProgressSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobProgressSummary =
      zio.aws.s3control.model.JobProgressSummary(
        totalNumberOfTasks.map(value => value),
        numberOfTasksSucceeded.map(value => value),
        numberOfTasksFailed.map(value => value),
        timers.map(value => value.asEditable)
      )
    def totalNumberOfTasks: Optional[JobTotalNumberOfTasks]
    def numberOfTasksSucceeded: Optional[JobNumberOfTasksSucceeded]
    def numberOfTasksFailed: Optional[JobNumberOfTasksFailed]
    def timers: Optional[zio.aws.s3control.model.JobTimers.ReadOnly]
    def getTotalNumberOfTasks: ZIO[Any, AwsError, JobTotalNumberOfTasks] =
      AwsError.unwrapOptionField("totalNumberOfTasks", totalNumberOfTasks)
    def getNumberOfTasksSucceeded
        : ZIO[Any, AwsError, JobNumberOfTasksSucceeded] = AwsError
      .unwrapOptionField("numberOfTasksSucceeded", numberOfTasksSucceeded)
    def getNumberOfTasksFailed: ZIO[Any, AwsError, JobNumberOfTasksFailed] =
      AwsError.unwrapOptionField("numberOfTasksFailed", numberOfTasksFailed)
    def getTimers
        : ZIO[Any, AwsError, zio.aws.s3control.model.JobTimers.ReadOnly] =
      AwsError.unwrapOptionField("timers", timers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobProgressSummary
  ) extends zio.aws.s3control.model.JobProgressSummary.ReadOnly {
    override val totalNumberOfTasks: Optional[JobTotalNumberOfTasks] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalNumberOfTasks())
        .map(value =>
          zio.aws.s3control.model.primitives.JobTotalNumberOfTasks(value)
        )
    override val numberOfTasksSucceeded: Optional[JobNumberOfTasksSucceeded] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfTasksSucceeded())
        .map(value =>
          zio.aws.s3control.model.primitives.JobNumberOfTasksSucceeded(value)
        )
    override val numberOfTasksFailed: Optional[JobNumberOfTasksFailed] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfTasksFailed())
        .map(value =>
          zio.aws.s3control.model.primitives.JobNumberOfTasksFailed(value)
        )
    override val timers: Optional[zio.aws.s3control.model.JobTimers.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timers())
        .map(value => zio.aws.s3control.model.JobTimers.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobProgressSummary
  ): zio.aws.s3control.model.JobProgressSummary.ReadOnly = new Wrapper(impl)
}
