package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetStorageLensConfigurationResponse(
    storageLensConfiguration: Optional[
      zio.aws.s3control.model.StorageLensConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationResponse = {
    import GetStorageLensConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationResponse
      .builder()
      .optionallyWith(
        storageLensConfiguration.map(value => value.buildAwsValue())
      )(_.storageLensConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetStorageLensConfigurationResponse.ReadOnly =
    zio.aws.s3control.model.GetStorageLensConfigurationResponse
      .wrap(buildAwsValue())
}
object GetStorageLensConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetStorageLensConfigurationResponse =
      zio.aws.s3control.model.GetStorageLensConfigurationResponse(
        storageLensConfiguration.map(value => value.asEditable)
      )
    def storageLensConfiguration
        : Optional[zio.aws.s3control.model.StorageLensConfiguration.ReadOnly]
    def getStorageLensConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.StorageLensConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "storageLensConfiguration",
      storageLensConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationResponse
  ) extends zio.aws.s3control.model.GetStorageLensConfigurationResponse.ReadOnly {
    override val storageLensConfiguration
        : Optional[zio.aws.s3control.model.StorageLensConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageLensConfiguration())
        .map(value =>
          zio.aws.s3control.model.StorageLensConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationResponse
  ): zio.aws.s3control.model.GetStorageLensConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
