package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{
  MultiRegionAccessPointClientToken,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class DeleteMultiRegionAccessPointRequest(
    accountId: AccountId,
    clientToken: MultiRegionAccessPointClientToken,
    details: zio.aws.s3control.model.DeleteMultiRegionAccessPointInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointRequest = {
    import DeleteMultiRegionAccessPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .clientToken(
        MultiRegionAccessPointClientToken.unwrap(clientToken): java.lang.String
      )
      .details(details.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.DeleteMultiRegionAccessPointRequest.ReadOnly =
    zio.aws.s3control.model.DeleteMultiRegionAccessPointRequest
      .wrap(buildAwsValue())
}
object DeleteMultiRegionAccessPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.DeleteMultiRegionAccessPointRequest =
      zio.aws.s3control.model.DeleteMultiRegionAccessPointRequest(
        accountId,
        clientToken,
        details.asEditable
      )
    def accountId: AccountId
    def clientToken: MultiRegionAccessPointClientToken
    def details
        : zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getClientToken: ZIO[Any, Nothing, MultiRegionAccessPointClientToken] =
      ZIO.succeed(clientToken)
    def getDetails: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly
    ] = ZIO.succeed(details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointRequest
  ) extends zio.aws.s3control.model.DeleteMultiRegionAccessPointRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val clientToken: MultiRegionAccessPointClientToken =
      zio.aws.s3control.model.primitives
        .MultiRegionAccessPointClientToken(impl.clientToken())
    override val details
        : zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly =
      zio.aws.s3control.model.DeleteMultiRegionAccessPointInput
        .wrap(impl.details())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointRequest
  ): zio.aws.s3control.model.DeleteMultiRegionAccessPointRequest.ReadOnly =
    new Wrapper(impl)
}
