package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait BucketLocationConstraint {
  def unwrap
      : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint
}
object BucketLocationConstraint {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.BucketLocationConstraint
  ): zio.aws.s3control.model.BucketLocationConstraint = value match {
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.EU =>
      val r = EU
      r
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.EU_WEST_1 =>
      val r = `eu-west-1`
      r
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.US_WEST_1 =>
      val r = `us-west-1`
      r
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.US_WEST_2 =>
      val r = `us-west-2`
      r
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.AP_SOUTH_1 =>
      val r = `ap-south-1`
      r
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.AP_SOUTHEAST_1 =>
      val r = `ap-southeast-1`
      r
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.AP_SOUTHEAST_2 =>
      val r = `ap-southeast-2`
      r
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.AP_NORTHEAST_1 =>
      val r = `ap-northeast-1`
      r
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.SA_EAST_1 =>
      val r = `sa-east-1`
      r
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.CN_NORTH_1 =>
      val r = `cn-north-1`
      r
    case software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.EU_CENTRAL_1 =>
      val r = `eu-central-1`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.UNKNOWN_TO_SDK_VERSION
  }
  case object EU extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.EU
  }
  case object `eu-west-1`
      extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.EU_WEST_1
  }
  case object `us-west-1`
      extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.US_WEST_1
  }
  case object `us-west-2`
      extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.US_WEST_2
  }
  case object `ap-south-1`
      extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.AP_SOUTH_1
  }
  case object `ap-southeast-1`
      extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.AP_SOUTHEAST_1
  }
  case object `ap-southeast-2`
      extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.AP_SOUTHEAST_2
  }
  case object `ap-northeast-1`
      extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.AP_NORTHEAST_1
  }
  case object `sa-east-1`
      extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.SA_EAST_1
  }
  case object `cn-north-1`
      extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.CN_NORTH_1
  }
  case object `eu-central-1`
      extends zio.aws.s3control.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3control.model.BucketLocationConstraint.EU_CENTRAL_1
  }
}
