package zio.aws.s3control
import zio.aws.s3control.model.PutJobTaggingResponse.ReadOnly
import software.amazon.awssdk.services.s3control.model.{
  PutBucketTaggingResponse,
  PutAccessPointPolicyForObjectLambdaRequest,
  PutBucketLifecycleConfigurationResponse,
  PutBucketPolicyRequest,
  CreateMultiRegionAccessPointRequest,
  DeleteBucketLifecycleConfigurationRequest,
  ListMultiRegionAccessPointsRequest,
  ObjectLambdaAccessPoint,
  GetBucketVersioningRequest,
  GetAccessPointPolicyStatusRequest,
  GetBucketRequest,
  PutAccessPointPolicyForObjectLambdaResponse,
  PutBucketLifecycleConfigurationRequest,
  GetMultiRegionAccessPointPolicyStatusRequest,
  JobListDescriptor,
  GetBucketLifecycleConfigurationResponse,
  PutAccessPointConfigurationForObjectLambdaRequest,
  GetAccessPointConfigurationForObjectLambdaRequest,
  PutBucketVersioningRequest,
  GetPublicAccessBlockResponse,
  GetAccessPointPolicyResponse,
  GetBucketPolicyRequest,
  GetStorageLensConfigurationRequest,
  DescribeMultiRegionAccessPointOperationRequest,
  PutMultiRegionAccessPointPolicyResponse,
  GetStorageLensConfigurationResponse,
  GetAccessPointForObjectLambdaRequest,
  DeleteBucketTaggingRequest,
  MultiRegionAccessPointReport,
  ListJobsRequest,
  PutPublicAccessBlockResponse,
  GetAccessPointPolicyForObjectLambdaRequest,
  GetAccessPointRequest,
  CreateAccessPointForObjectLambdaRequest,
  DescribeJobRequest,
  PutStorageLensConfigurationResponse,
  DeletePublicAccessBlockResponse,
  AccessPoint,
  ListStorageLensConfigurationEntry,
  GetBucketTaggingResponse,
  GetMultiRegionAccessPointRequest,
  DescribeJobResponse,
  DeleteAccessPointPolicyResponse,
  ListAccessPointsResponse,
  DeleteAccessPointForObjectLambdaRequest,
  DeleteStorageLensConfigurationTaggingRequest,
  GetBucketPolicyResponse,
  DeleteJobTaggingRequest,
  PutStorageLensConfigurationTaggingRequest,
  PutPublicAccessBlockRequest,
  CreateBucketResponse,
  DeleteBucketResponse,
  GetBucketTaggingRequest,
  DeleteBucketTaggingResponse,
  GetAccessPointForObjectLambdaResponse,
  DeleteAccessPointPolicyForObjectLambdaRequest,
  GetBucketResponse,
  GetStorageLensConfigurationTaggingRequest,
  CreateAccessPointForObjectLambdaResponse,
  GetJobTaggingRequest,
  GetAccessPointConfigurationForObjectLambdaResponse,
  GetPublicAccessBlockRequest,
  DeleteBucketPolicyResponse,
  DeletePublicAccessBlockRequest,
  GetAccessPointPolicyForObjectLambdaResponse,
  GetStorageLensConfigurationTaggingResponse,
  ListAccessPointsRequest,
  ListRegionalBucketsResponse,
  GetMultiRegionAccessPointPolicyResponse,
  CreateAccessPointResponse,
  GetJobTaggingResponse,
  CreateMultiRegionAccessPointResponse,
  DeleteAccessPointPolicyRequest,
  GetBucketLifecycleConfigurationRequest,
  DeleteBucketRequest,
  PutBucketVersioningResponse,
  DeleteBucketLifecycleConfigurationResponse,
  PutStorageLensConfigurationTaggingResponse,
  ListAccessPointsForObjectLambdaResponse,
  RegionalBucket,
  PutBucketPolicyResponse,
  GetAccessPointPolicyStatusResponse,
  ListStorageLensConfigurationsResponse,
  UpdateJobStatusRequest,
  CreateBucketRequest,
  ListAccessPointsForObjectLambdaRequest,
  GetAccessPointPolicyRequest,
  UpdateJobStatusResponse,
  DeleteAccessPointForObjectLambdaResponse,
  PutJobTaggingResponse,
  DeleteStorageLensConfigurationRequest,
  PutStorageLensConfigurationRequest,
  DeleteBucketPolicyRequest,
  PutJobTaggingRequest,
  ListStorageLensConfigurationsRequest,
  CreateJobRequest,
  DeleteStorageLensConfigurationResponse,
  GetAccessPointPolicyStatusForObjectLambdaResponse,
  DeleteMultiRegionAccessPointRequest,
  DeleteAccessPointPolicyForObjectLambdaResponse,
  GetBucketVersioningResponse,
  DeleteMultiRegionAccessPointResponse,
  UpdateJobPriorityRequest,
  PutMultiRegionAccessPointPolicyRequest,
  DeleteJobTaggingResponse,
  GetMultiRegionAccessPointPolicyRequest,
  ListJobsResponse,
  DeleteAccessPointResponse,
  PutAccessPointPolicyRequest,
  PutBucketTaggingRequest,
  PutAccessPointConfigurationForObjectLambdaResponse,
  GetMultiRegionAccessPointResponse,
  ListMultiRegionAccessPointsResponse,
  ListRegionalBucketsRequest,
  GetAccessPointResponse,
  PutAccessPointPolicyResponse,
  DeleteAccessPointRequest,
  GetAccessPointPolicyStatusForObjectLambdaRequest,
  DeleteStorageLensConfigurationTaggingResponse,
  DescribeMultiRegionAccessPointOperationResponse,
  GetMultiRegionAccessPointPolicyStatusResponse,
  CreateAccessPointRequest,
  CreateJobResponse,
  UpdateJobPriorityResponse
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.s3control.{
  S3ControlAsyncClientBuilder,
  S3ControlAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait S3Control extends AspectSupport[S3Control] {
  val api: S3ControlAsyncClient
  def putBucketPolicy(
      request: zio.aws.s3control.model.PutBucketPolicyRequest
  ): IO[AwsError, Unit]
  def getBucketPolicy(
      request: zio.aws.s3control.model.GetBucketPolicyRequest
  ): IO[AwsError, zio.aws.s3control.model.GetBucketPolicyResponse.ReadOnly]
  def createMultiRegionAccessPoint(
      request: zio.aws.s3control.model.CreateMultiRegionAccessPointRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.CreateMultiRegionAccessPointResponse.ReadOnly
  ]
  def describeJob(
      request: zio.aws.s3control.model.DescribeJobRequest
  ): IO[AwsError, zio.aws.s3control.model.DescribeJobResponse.ReadOnly]
  def getBucket(
      request: zio.aws.s3control.model.GetBucketRequest
  ): IO[AwsError, zio.aws.s3control.model.GetBucketResponse.ReadOnly]
  def deleteAccessPointPolicy(
      request: zio.aws.s3control.model.DeleteAccessPointPolicyRequest
  ): IO[AwsError, Unit]
  def putBucketLifecycleConfiguration(
      request: zio.aws.s3control.model.PutBucketLifecycleConfigurationRequest
  ): IO[AwsError, Unit]
  def createAccessPoint(
      request: zio.aws.s3control.model.CreateAccessPointRequest
  ): IO[AwsError, zio.aws.s3control.model.CreateAccessPointResponse.ReadOnly]
  def deleteBucketPolicy(
      request: zio.aws.s3control.model.DeleteBucketPolicyRequest
  ): IO[AwsError, Unit]
  def getAccessPointPolicyStatusForObjectLambda(
      request: zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse.ReadOnly
  ]
  def getBucketLifecycleConfiguration(
      request: zio.aws.s3control.model.GetBucketLifecycleConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse.ReadOnly
  ]
  def deleteJobTagging(
      request: zio.aws.s3control.model.DeleteJobTaggingRequest
  ): IO[AwsError, zio.aws.s3control.model.DeleteJobTaggingResponse.ReadOnly]
  def deleteBucketLifecycleConfiguration(
      request: zio.aws.s3control.model.DeleteBucketLifecycleConfigurationRequest
  ): IO[AwsError, Unit]
  def createJob(
      request: zio.aws.s3control.model.CreateJobRequest
  ): IO[AwsError, zio.aws.s3control.model.CreateJobResponse.ReadOnly]
  def getStorageLensConfiguration(
      request: zio.aws.s3control.model.GetStorageLensConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.GetStorageLensConfigurationResponse.ReadOnly
  ]
  def deleteAccessPointPolicyForObjectLambda(
      request: zio.aws.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest
  ): IO[AwsError, Unit]
  def putAccessPointConfigurationForObjectLambda(
      request: zio.aws.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest
  ): IO[AwsError, Unit]
  def putAccessPointPolicy(
      request: zio.aws.s3control.model.PutAccessPointPolicyRequest
  ): IO[AwsError, Unit]
  def putAccessPointPolicyForObjectLambda(
      request: zio.aws.s3control.model.PutAccessPointPolicyForObjectLambdaRequest
  ): IO[AwsError, Unit]
  def getMultiRegionAccessPoint(
      request: zio.aws.s3control.model.GetMultiRegionAccessPointRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.GetMultiRegionAccessPointResponse.ReadOnly
  ]
  def getAccessPoint(
      request: zio.aws.s3control.model.GetAccessPointRequest
  ): IO[AwsError, zio.aws.s3control.model.GetAccessPointResponse.ReadOnly]
  def deleteStorageLensConfigurationTagging(
      request: zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingResponse.ReadOnly
  ]
  def deleteBucket(
      request: zio.aws.s3control.model.DeleteBucketRequest
  ): IO[AwsError, Unit]
  def createBucket(
      request: zio.aws.s3control.model.CreateBucketRequest
  ): IO[AwsError, zio.aws.s3control.model.CreateBucketResponse.ReadOnly]
  def updateJobStatus(
      request: zio.aws.s3control.model.UpdateJobStatusRequest
  ): IO[AwsError, zio.aws.s3control.model.UpdateJobStatusResponse.ReadOnly]
  def getBucketTagging(
      request: zio.aws.s3control.model.GetBucketTaggingRequest
  ): IO[AwsError, zio.aws.s3control.model.GetBucketTaggingResponse.ReadOnly]
  def putStorageLensConfiguration(
      request: zio.aws.s3control.model.PutStorageLensConfigurationRequest
  ): IO[AwsError, Unit]
  def putBucketTagging(
      request: zio.aws.s3control.model.PutBucketTaggingRequest
  ): IO[AwsError, Unit]
  def deleteBucketTagging(
      request: zio.aws.s3control.model.DeleteBucketTaggingRequest
  ): IO[AwsError, Unit]
  def updateJobPriority(
      request: zio.aws.s3control.model.UpdateJobPriorityRequest
  ): IO[AwsError, zio.aws.s3control.model.UpdateJobPriorityResponse.ReadOnly]
  def listStorageLensConfigurations(
      request: zio.aws.s3control.model.ListStorageLensConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly
  ]
  def listStorageLensConfigurationsPaginated(
      request: zio.aws.s3control.model.ListStorageLensConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.ListStorageLensConfigurationsResponse.ReadOnly
  ]
  def putPublicAccessBlock(
      request: zio.aws.s3control.model.PutPublicAccessBlockRequest
  ): IO[AwsError, Unit]
  def getMultiRegionAccessPointPolicy(
      request: zio.aws.s3control.model.GetMultiRegionAccessPointPolicyRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse.ReadOnly
  ]
  def getBucketVersioning(
      request: zio.aws.s3control.model.GetBucketVersioningRequest
  ): IO[AwsError, zio.aws.s3control.model.GetBucketVersioningResponse.ReadOnly]
  def listRegionalBuckets(
      request: zio.aws.s3control.model.ListRegionalBucketsRequest
  ): ZStream[Any, AwsError, zio.aws.s3control.model.RegionalBucket.ReadOnly]
  def listRegionalBucketsPaginated(
      request: zio.aws.s3control.model.ListRegionalBucketsRequest
  ): IO[AwsError, zio.aws.s3control.model.ListRegionalBucketsResponse.ReadOnly]
  def getAccessPointPolicyForObjectLambda(
      request: zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaResponse.ReadOnly
  ]
  def getAccessPointForObjectLambda(
      request: zio.aws.s3control.model.GetAccessPointForObjectLambdaRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.ReadOnly
  ]
  def listJobs(
      request: zio.aws.s3control.model.ListJobsRequest
  ): ZStream[Any, AwsError, zio.aws.s3control.model.JobListDescriptor.ReadOnly]
  def listJobsPaginated(
      request: zio.aws.s3control.model.ListJobsRequest
  ): IO[AwsError, zio.aws.s3control.model.ListJobsResponse.ReadOnly]
  def listAccessPointsForObjectLambda(
      request: zio.aws.s3control.model.ListAccessPointsForObjectLambdaRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly
  ]
  def listAccessPointsForObjectLambdaPaginated(
      request: zio.aws.s3control.model.ListAccessPointsForObjectLambdaRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse.ReadOnly
  ]
  def putBucketVersioning(
      request: zio.aws.s3control.model.PutBucketVersioningRequest
  ): IO[AwsError, Unit]
  def listMultiRegionAccessPoints(
      request: zio.aws.s3control.model.ListMultiRegionAccessPointsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly
  ]
  def listMultiRegionAccessPointsPaginated(
      request: zio.aws.s3control.model.ListMultiRegionAccessPointsRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.ListMultiRegionAccessPointsResponse.ReadOnly
  ]
  def getMultiRegionAccessPointPolicyStatus(
      request: zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse.ReadOnly
  ]
  def getPublicAccessBlock(
      request: zio.aws.s3control.model.GetPublicAccessBlockRequest
  ): IO[AwsError, zio.aws.s3control.model.GetPublicAccessBlockResponse.ReadOnly]
  def deleteMultiRegionAccessPoint(
      request: zio.aws.s3control.model.DeleteMultiRegionAccessPointRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse.ReadOnly
  ]
  def getAccessPointPolicyStatus(
      request: zio.aws.s3control.model.GetAccessPointPolicyStatusRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.GetAccessPointPolicyStatusResponse.ReadOnly
  ]
  def getStorageLensConfigurationTagging(
      request: zio.aws.s3control.model.GetStorageLensConfigurationTaggingRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse.ReadOnly
  ]
  def describeMultiRegionAccessPointOperation(
      request: zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse.ReadOnly
  ]
  def deleteAccessPointForObjectLambda(
      request: zio.aws.s3control.model.DeleteAccessPointForObjectLambdaRequest
  ): IO[AwsError, Unit]
  def listAccessPoints(
      request: zio.aws.s3control.model.ListAccessPointsRequest
  ): ZStream[Any, AwsError, zio.aws.s3control.model.AccessPoint.ReadOnly]
  def listAccessPointsPaginated(
      request: zio.aws.s3control.model.ListAccessPointsRequest
  ): IO[AwsError, zio.aws.s3control.model.ListAccessPointsResponse.ReadOnly]
  def getAccessPointPolicy(
      request: zio.aws.s3control.model.GetAccessPointPolicyRequest
  ): IO[AwsError, zio.aws.s3control.model.GetAccessPointPolicyResponse.ReadOnly]
  def deleteStorageLensConfiguration(
      request: zio.aws.s3control.model.DeleteStorageLensConfigurationRequest
  ): IO[AwsError, Unit]
  def createAccessPointForObjectLambda(
      request: zio.aws.s3control.model.CreateAccessPointForObjectLambdaRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.ReadOnly
  ]
  def putJobTagging(
      request: zio.aws.s3control.model.PutJobTaggingRequest
  ): IO[AwsError, ReadOnly]
  def deletePublicAccessBlock(
      request: zio.aws.s3control.model.DeletePublicAccessBlockRequest
  ): IO[AwsError, Unit]
  def deleteAccessPoint(
      request: zio.aws.s3control.model.DeleteAccessPointRequest
  ): IO[AwsError, Unit]
  def putMultiRegionAccessPointPolicy(
      request: zio.aws.s3control.model.PutMultiRegionAccessPointPolicyRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse.ReadOnly
  ]
  def getJobTagging(
      request: zio.aws.s3control.model.GetJobTaggingRequest
  ): IO[AwsError, zio.aws.s3control.model.GetJobTaggingResponse.ReadOnly]
  def putStorageLensConfigurationTagging(
      request: zio.aws.s3control.model.PutStorageLensConfigurationTaggingRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.PutStorageLensConfigurationTaggingResponse.ReadOnly
  ]
  def getAccessPointConfigurationForObjectLambda(
      request: zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest
  ): IO[
    AwsError,
    zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse.ReadOnly
  ]
}
object S3Control {
  val live: ZLayer[AwsConfig, java.lang.Throwable, S3Control] = customized(
    identity
  )
  def customized(
      customization: S3ControlAsyncClientBuilder => S3ControlAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, S3Control] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: S3ControlAsyncClientBuilder => S3ControlAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, S3Control] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = S3ControlAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[S3ControlAsyncClient, S3ControlAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[S3ControlAsyncClient, S3ControlAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new S3ControlImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class S3ControlImpl[R](
      override val api: S3ControlAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends S3Control
      with AwsServiceBase[R] {
    override val serviceName: String = "S3Control"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): S3ControlImpl[R1] = new S3ControlImpl(api, newAspect, r)
    def putBucketPolicy(
        request: zio.aws.s3control.model.PutBucketPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutBucketPolicyRequest, PutBucketPolicyResponse](
        "putBucketPolicy",
        api.putBucketPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getBucketPolicy(
        request: zio.aws.s3control.model.GetBucketPolicyRequest
    ): IO[AwsError, zio.aws.s3control.model.GetBucketPolicyResponse.ReadOnly] =
      asyncRequestResponse[GetBucketPolicyRequest, GetBucketPolicyResponse](
        "getBucketPolicy",
        api.getBucketPolicy
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.GetBucketPolicyResponse.wrap)
        .provideEnvironment(r)
    def createMultiRegionAccessPoint(
        request: zio.aws.s3control.model.CreateMultiRegionAccessPointRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.CreateMultiRegionAccessPointResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateMultiRegionAccessPointRequest,
      CreateMultiRegionAccessPointResponse
    ]("createMultiRegionAccessPoint", api.createMultiRegionAccessPoint)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.CreateMultiRegionAccessPointResponse.wrap)
      .provideEnvironment(r)
    def describeJob(
        request: zio.aws.s3control.model.DescribeJobRequest
    ): IO[AwsError, zio.aws.s3control.model.DescribeJobResponse.ReadOnly] =
      asyncRequestResponse[DescribeJobRequest, DescribeJobResponse](
        "describeJob",
        api.describeJob
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.DescribeJobResponse.wrap)
        .provideEnvironment(r)
    def getBucket(
        request: zio.aws.s3control.model.GetBucketRequest
    ): IO[AwsError, zio.aws.s3control.model.GetBucketResponse.ReadOnly] =
      asyncRequestResponse[GetBucketRequest, GetBucketResponse](
        "getBucket",
        api.getBucket
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.GetBucketResponse.wrap)
        .provideEnvironment(r)
    def deleteAccessPointPolicy(
        request: zio.aws.s3control.model.DeleteAccessPointPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteAccessPointPolicyRequest,
      DeleteAccessPointPolicyResponse
    ]("deleteAccessPointPolicy", api.deleteAccessPointPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putBucketLifecycleConfiguration(
        request: zio.aws.s3control.model.PutBucketLifecycleConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketLifecycleConfigurationRequest,
      PutBucketLifecycleConfigurationResponse
    ]("putBucketLifecycleConfiguration", api.putBucketLifecycleConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createAccessPoint(
        request: zio.aws.s3control.model.CreateAccessPointRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.CreateAccessPointResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateAccessPointRequest, CreateAccessPointResponse](
        "createAccessPoint",
        api.createAccessPoint
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.CreateAccessPointResponse.wrap)
        .provideEnvironment(r)
    def deleteBucketPolicy(
        request: zio.aws.s3control.model.DeleteBucketPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketPolicyRequest,
      DeleteBucketPolicyResponse
    ]("deleteBucketPolicy", api.deleteBucketPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getAccessPointPolicyStatusForObjectLambda(
        request: zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccessPointPolicyStatusForObjectLambdaRequest,
      GetAccessPointPolicyStatusForObjectLambdaResponse
    ](
      "getAccessPointPolicyStatusForObjectLambda",
      api.getAccessPointPolicyStatusForObjectLambda
    )(request.buildAwsValue())
      .map(
        zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse.wrap
      )
      .provideEnvironment(r)
    def getBucketLifecycleConfiguration(
        request: zio.aws.s3control.model.GetBucketLifecycleConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketLifecycleConfigurationRequest,
      GetBucketLifecycleConfigurationResponse
    ]("getBucketLifecycleConfiguration", api.getBucketLifecycleConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteJobTagging(
        request: zio.aws.s3control.model.DeleteJobTaggingRequest
    ): IO[AwsError, zio.aws.s3control.model.DeleteJobTaggingResponse.ReadOnly] =
      asyncRequestResponse[DeleteJobTaggingRequest, DeleteJobTaggingResponse](
        "deleteJobTagging",
        api.deleteJobTagging
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.DeleteJobTaggingResponse.wrap)
        .provideEnvironment(r)
    def deleteBucketLifecycleConfiguration(
        request: zio.aws.s3control.model.DeleteBucketLifecycleConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketLifecycleConfigurationRequest,
      DeleteBucketLifecycleConfigurationResponse
    ](
      "deleteBucketLifecycleConfiguration",
      api.deleteBucketLifecycleConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createJob(
        request: zio.aws.s3control.model.CreateJobRequest
    ): IO[AwsError, zio.aws.s3control.model.CreateJobResponse.ReadOnly] =
      asyncRequestResponse[CreateJobRequest, CreateJobResponse](
        "createJob",
        api.createJob
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.CreateJobResponse.wrap)
        .provideEnvironment(r)
    def getStorageLensConfiguration(
        request: zio.aws.s3control.model.GetStorageLensConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetStorageLensConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetStorageLensConfigurationRequest,
      GetStorageLensConfigurationResponse
    ]("getStorageLensConfiguration", api.getStorageLensConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.GetStorageLensConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteAccessPointPolicyForObjectLambda(
        request: zio.aws.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteAccessPointPolicyForObjectLambdaRequest,
      DeleteAccessPointPolicyForObjectLambdaResponse
    ](
      "deleteAccessPointPolicyForObjectLambda",
      api.deleteAccessPointPolicyForObjectLambda
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putAccessPointConfigurationForObjectLambda(
        request: zio.aws.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutAccessPointConfigurationForObjectLambdaRequest,
      PutAccessPointConfigurationForObjectLambdaResponse
    ](
      "putAccessPointConfigurationForObjectLambda",
      api.putAccessPointConfigurationForObjectLambda
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putAccessPointPolicy(
        request: zio.aws.s3control.model.PutAccessPointPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutAccessPointPolicyRequest,
      PutAccessPointPolicyResponse
    ]("putAccessPointPolicy", api.putAccessPointPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putAccessPointPolicyForObjectLambda(
        request: zio.aws.s3control.model.PutAccessPointPolicyForObjectLambdaRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutAccessPointPolicyForObjectLambdaRequest,
      PutAccessPointPolicyForObjectLambdaResponse
    ](
      "putAccessPointPolicyForObjectLambda",
      api.putAccessPointPolicyForObjectLambda
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getMultiRegionAccessPoint(
        request: zio.aws.s3control.model.GetMultiRegionAccessPointRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetMultiRegionAccessPointResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMultiRegionAccessPointRequest,
      GetMultiRegionAccessPointResponse
    ]("getMultiRegionAccessPoint", api.getMultiRegionAccessPoint)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.GetMultiRegionAccessPointResponse.wrap)
      .provideEnvironment(r)
    def getAccessPoint(
        request: zio.aws.s3control.model.GetAccessPointRequest
    ): IO[AwsError, zio.aws.s3control.model.GetAccessPointResponse.ReadOnly] =
      asyncRequestResponse[GetAccessPointRequest, GetAccessPointResponse](
        "getAccessPoint",
        api.getAccessPoint
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.GetAccessPointResponse.wrap)
        .provideEnvironment(r)
    def deleteStorageLensConfigurationTagging(
        request: zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteStorageLensConfigurationTaggingRequest,
      DeleteStorageLensConfigurationTaggingResponse
    ](
      "deleteStorageLensConfigurationTagging",
      api.deleteStorageLensConfigurationTagging
    )(request.buildAwsValue())
      .map(
        zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingResponse.wrap
      )
      .provideEnvironment(r)
    def deleteBucket(
        request: zio.aws.s3control.model.DeleteBucketRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteBucketRequest, DeleteBucketResponse](
        "deleteBucket",
        api.deleteBucket
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createBucket(
        request: zio.aws.s3control.model.CreateBucketRequest
    ): IO[AwsError, zio.aws.s3control.model.CreateBucketResponse.ReadOnly] =
      asyncRequestResponse[CreateBucketRequest, CreateBucketResponse](
        "createBucket",
        api.createBucket
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.CreateBucketResponse.wrap)
        .provideEnvironment(r)
    def updateJobStatus(
        request: zio.aws.s3control.model.UpdateJobStatusRequest
    ): IO[AwsError, zio.aws.s3control.model.UpdateJobStatusResponse.ReadOnly] =
      asyncRequestResponse[UpdateJobStatusRequest, UpdateJobStatusResponse](
        "updateJobStatus",
        api.updateJobStatus
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.UpdateJobStatusResponse.wrap)
        .provideEnvironment(r)
    def getBucketTagging(
        request: zio.aws.s3control.model.GetBucketTaggingRequest
    ): IO[AwsError, zio.aws.s3control.model.GetBucketTaggingResponse.ReadOnly] =
      asyncRequestResponse[GetBucketTaggingRequest, GetBucketTaggingResponse](
        "getBucketTagging",
        api.getBucketTagging
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.GetBucketTaggingResponse.wrap)
        .provideEnvironment(r)
    def putStorageLensConfiguration(
        request: zio.aws.s3control.model.PutStorageLensConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutStorageLensConfigurationRequest,
      PutStorageLensConfigurationResponse
    ]("putStorageLensConfiguration", api.putStorageLensConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putBucketTagging(
        request: zio.aws.s3control.model.PutBucketTaggingRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutBucketTaggingRequest, PutBucketTaggingResponse](
        "putBucketTagging",
        api.putBucketTagging
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteBucketTagging(
        request: zio.aws.s3control.model.DeleteBucketTaggingRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketTaggingRequest,
      DeleteBucketTaggingResponse
    ]("deleteBucketTagging", api.deleteBucketTagging)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateJobPriority(
        request: zio.aws.s3control.model.UpdateJobPriorityRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.UpdateJobPriorityResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateJobPriorityRequest, UpdateJobPriorityResponse](
        "updateJobPriority",
        api.updateJobPriority
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.UpdateJobPriorityResponse.wrap)
        .provideEnvironment(r)
    def listStorageLensConfigurations(
        request: zio.aws.s3control.model.ListStorageLensConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListStorageLensConfigurationsRequest,
      ListStorageLensConfigurationsResponse,
      ListStorageLensConfigurationEntry
    ](
      "listStorageLensConfigurations",
      api.listStorageLensConfigurations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.storageLensConfigurationList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.s3control.model.ListStorageLensConfigurationEntry.wrap(item)
      )
      .provideEnvironment(r)
    def listStorageLensConfigurationsPaginated(
        request: zio.aws.s3control.model.ListStorageLensConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.ListStorageLensConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListStorageLensConfigurationsRequest,
      ListStorageLensConfigurationsResponse
    ]("listStorageLensConfigurations", api.listStorageLensConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.ListStorageLensConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def putPublicAccessBlock(
        request: zio.aws.s3control.model.PutPublicAccessBlockRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutPublicAccessBlockRequest,
      PutPublicAccessBlockResponse
    ]("putPublicAccessBlock", api.putPublicAccessBlock)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getMultiRegionAccessPointPolicy(
        request: zio.aws.s3control.model.GetMultiRegionAccessPointPolicyRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMultiRegionAccessPointPolicyRequest,
      GetMultiRegionAccessPointPolicyResponse
    ]("getMultiRegionAccessPointPolicy", api.getMultiRegionAccessPointPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse.wrap)
      .provideEnvironment(r)
    def getBucketVersioning(
        request: zio.aws.s3control.model.GetBucketVersioningRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetBucketVersioningResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketVersioningRequest,
      GetBucketVersioningResponse
    ]("getBucketVersioning", api.getBucketVersioning)(request.buildAwsValue())
      .map(zio.aws.s3control.model.GetBucketVersioningResponse.wrap)
      .provideEnvironment(r)
    def listRegionalBuckets(
        request: zio.aws.s3control.model.ListRegionalBucketsRequest
    ): ZStream[Any, AwsError, zio.aws.s3control.model.RegionalBucket.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListRegionalBucketsRequest,
        ListRegionalBucketsResponse,
        RegionalBucket
      ](
        "listRegionalBuckets",
        api.listRegionalBuckets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.regionalBucketList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.s3control.model.RegionalBucket.wrap(item))
        .provideEnvironment(r)
    def listRegionalBucketsPaginated(
        request: zio.aws.s3control.model.ListRegionalBucketsRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.ListRegionalBucketsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListRegionalBucketsRequest,
      ListRegionalBucketsResponse
    ]("listRegionalBuckets", api.listRegionalBuckets)(request.buildAwsValue())
      .map(zio.aws.s3control.model.ListRegionalBucketsResponse.wrap)
      .provideEnvironment(r)
    def getAccessPointPolicyForObjectLambda(
        request: zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccessPointPolicyForObjectLambdaRequest,
      GetAccessPointPolicyForObjectLambdaResponse
    ](
      "getAccessPointPolicyForObjectLambda",
      api.getAccessPointPolicyForObjectLambda
    )(request.buildAwsValue())
      .map(
        zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaResponse.wrap
      )
      .provideEnvironment(r)
    def getAccessPointForObjectLambda(
        request: zio.aws.s3control.model.GetAccessPointForObjectLambdaRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccessPointForObjectLambdaRequest,
      GetAccessPointForObjectLambdaResponse
    ]("getAccessPointForObjectLambda", api.getAccessPointForObjectLambda)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.wrap)
      .provideEnvironment(r)
    def listJobs(request: zio.aws.s3control.model.ListJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.s3control.model.JobListDescriptor.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListJobsRequest,
      ListJobsResponse,
      JobListDescriptor
    ](
      "listJobs",
      api.listJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.jobs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.s3control.model.JobListDescriptor.wrap(item))
      .provideEnvironment(r)
    def listJobsPaginated(
        request: zio.aws.s3control.model.ListJobsRequest
    ): IO[AwsError, zio.aws.s3control.model.ListJobsResponse.ReadOnly] =
      asyncRequestResponse[ListJobsRequest, ListJobsResponse](
        "listJobs",
        api.listJobs
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.ListJobsResponse.wrap)
        .provideEnvironment(r)
    def listAccessPointsForObjectLambda(
        request: zio.aws.s3control.model.ListAccessPointsForObjectLambdaRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListAccessPointsForObjectLambdaRequest,
      ListAccessPointsForObjectLambdaResponse,
      ObjectLambdaAccessPoint
    ](
      "listAccessPointsForObjectLambda",
      api.listAccessPointsForObjectLambda,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.objectLambdaAccessPointList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.s3control.model.ObjectLambdaAccessPoint.wrap(item))
      .provideEnvironment(r)
    def listAccessPointsForObjectLambdaPaginated(
        request: zio.aws.s3control.model.ListAccessPointsForObjectLambdaRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAccessPointsForObjectLambdaRequest,
      ListAccessPointsForObjectLambdaResponse
    ]("listAccessPointsForObjectLambda", api.listAccessPointsForObjectLambda)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse.wrap)
      .provideEnvironment(r)
    def putBucketVersioning(
        request: zio.aws.s3control.model.PutBucketVersioningRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketVersioningRequest,
      PutBucketVersioningResponse
    ]("putBucketVersioning", api.putBucketVersioning)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listMultiRegionAccessPoints(
        request: zio.aws.s3control.model.ListMultiRegionAccessPointsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListMultiRegionAccessPointsRequest,
      ListMultiRegionAccessPointsResponse,
      MultiRegionAccessPointReport
    ](
      "listMultiRegionAccessPoints",
      api.listMultiRegionAccessPoints,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accessPoints().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.s3control.model.MultiRegionAccessPointReport.wrap(item)
      )
      .provideEnvironment(r)
    def listMultiRegionAccessPointsPaginated(
        request: zio.aws.s3control.model.ListMultiRegionAccessPointsRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.ListMultiRegionAccessPointsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListMultiRegionAccessPointsRequest,
      ListMultiRegionAccessPointsResponse
    ]("listMultiRegionAccessPoints", api.listMultiRegionAccessPoints)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.ListMultiRegionAccessPointsResponse.wrap)
      .provideEnvironment(r)
    def getMultiRegionAccessPointPolicyStatus(
        request: zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMultiRegionAccessPointPolicyStatusRequest,
      GetMultiRegionAccessPointPolicyStatusResponse
    ](
      "getMultiRegionAccessPointPolicyStatus",
      api.getMultiRegionAccessPointPolicyStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse.wrap
      )
      .provideEnvironment(r)
    def getPublicAccessBlock(
        request: zio.aws.s3control.model.GetPublicAccessBlockRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetPublicAccessBlockResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPublicAccessBlockRequest,
      GetPublicAccessBlockResponse
    ]("getPublicAccessBlock", api.getPublicAccessBlock)(request.buildAwsValue())
      .map(zio.aws.s3control.model.GetPublicAccessBlockResponse.wrap)
      .provideEnvironment(r)
    def deleteMultiRegionAccessPoint(
        request: zio.aws.s3control.model.DeleteMultiRegionAccessPointRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteMultiRegionAccessPointRequest,
      DeleteMultiRegionAccessPointResponse
    ]("deleteMultiRegionAccessPoint", api.deleteMultiRegionAccessPoint)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse.wrap)
      .provideEnvironment(r)
    def getAccessPointPolicyStatus(
        request: zio.aws.s3control.model.GetAccessPointPolicyStatusRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetAccessPointPolicyStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccessPointPolicyStatusRequest,
      GetAccessPointPolicyStatusResponse
    ]("getAccessPointPolicyStatus", api.getAccessPointPolicyStatus)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.GetAccessPointPolicyStatusResponse.wrap)
      .provideEnvironment(r)
    def getStorageLensConfigurationTagging(
        request: zio.aws.s3control.model.GetStorageLensConfigurationTaggingRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse.ReadOnly
    ] = asyncRequestResponse[
      GetStorageLensConfigurationTaggingRequest,
      GetStorageLensConfigurationTaggingResponse
    ](
      "getStorageLensConfigurationTagging",
      api.getStorageLensConfigurationTagging
    )(request.buildAwsValue())
      .map(
        zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse.wrap
      )
      .provideEnvironment(r)
    def describeMultiRegionAccessPointOperation(
        request: zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMultiRegionAccessPointOperationRequest,
      DescribeMultiRegionAccessPointOperationResponse
    ](
      "describeMultiRegionAccessPointOperation",
      api.describeMultiRegionAccessPointOperation
    )(request.buildAwsValue())
      .map(
        zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteAccessPointForObjectLambda(
        request: zio.aws.s3control.model.DeleteAccessPointForObjectLambdaRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteAccessPointForObjectLambdaRequest,
      DeleteAccessPointForObjectLambdaResponse
    ]("deleteAccessPointForObjectLambda", api.deleteAccessPointForObjectLambda)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listAccessPoints(
        request: zio.aws.s3control.model.ListAccessPointsRequest
    ): ZStream[Any, AwsError, zio.aws.s3control.model.AccessPoint.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListAccessPointsRequest,
        ListAccessPointsResponse,
        AccessPoint
      ](
        "listAccessPoints",
        api.listAccessPoints,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.accessPointList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.s3control.model.AccessPoint.wrap(item))
        .provideEnvironment(r)
    def listAccessPointsPaginated(
        request: zio.aws.s3control.model.ListAccessPointsRequest
    ): IO[AwsError, zio.aws.s3control.model.ListAccessPointsResponse.ReadOnly] =
      asyncRequestResponse[ListAccessPointsRequest, ListAccessPointsResponse](
        "listAccessPoints",
        api.listAccessPoints
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.ListAccessPointsResponse.wrap)
        .provideEnvironment(r)
    def getAccessPointPolicy(
        request: zio.aws.s3control.model.GetAccessPointPolicyRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetAccessPointPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccessPointPolicyRequest,
      GetAccessPointPolicyResponse
    ]("getAccessPointPolicy", api.getAccessPointPolicy)(request.buildAwsValue())
      .map(zio.aws.s3control.model.GetAccessPointPolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteStorageLensConfiguration(
        request: zio.aws.s3control.model.DeleteStorageLensConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteStorageLensConfigurationRequest,
      DeleteStorageLensConfigurationResponse
    ]("deleteStorageLensConfiguration", api.deleteStorageLensConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createAccessPointForObjectLambda(
        request: zio.aws.s3control.model.CreateAccessPointForObjectLambdaRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateAccessPointForObjectLambdaRequest,
      CreateAccessPointForObjectLambdaResponse
    ]("createAccessPointForObjectLambda", api.createAccessPointForObjectLambda)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.wrap)
      .provideEnvironment(r)
    def putJobTagging(
        request: zio.aws.s3control.model.PutJobTaggingRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[PutJobTaggingRequest, PutJobTaggingResponse](
        "putJobTagging",
        api.putJobTagging
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.PutJobTaggingResponse.wrap)
        .provideEnvironment(r)
    def deletePublicAccessBlock(
        request: zio.aws.s3control.model.DeletePublicAccessBlockRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeletePublicAccessBlockRequest,
      DeletePublicAccessBlockResponse
    ]("deletePublicAccessBlock", api.deletePublicAccessBlock)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteAccessPoint(
        request: zio.aws.s3control.model.DeleteAccessPointRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAccessPointRequest, DeleteAccessPointResponse](
        "deleteAccessPoint",
        api.deleteAccessPoint
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putMultiRegionAccessPointPolicy(
        request: zio.aws.s3control.model.PutMultiRegionAccessPointPolicyRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      PutMultiRegionAccessPointPolicyRequest,
      PutMultiRegionAccessPointPolicyResponse
    ]("putMultiRegionAccessPointPolicy", api.putMultiRegionAccessPointPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse.wrap)
      .provideEnvironment(r)
    def getJobTagging(
        request: zio.aws.s3control.model.GetJobTaggingRequest
    ): IO[AwsError, zio.aws.s3control.model.GetJobTaggingResponse.ReadOnly] =
      asyncRequestResponse[GetJobTaggingRequest, GetJobTaggingResponse](
        "getJobTagging",
        api.getJobTagging
      )(request.buildAwsValue())
        .map(zio.aws.s3control.model.GetJobTaggingResponse.wrap)
        .provideEnvironment(r)
    def putStorageLensConfigurationTagging(
        request: zio.aws.s3control.model.PutStorageLensConfigurationTaggingRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.PutStorageLensConfigurationTaggingResponse.ReadOnly
    ] = asyncRequestResponse[
      PutStorageLensConfigurationTaggingRequest,
      PutStorageLensConfigurationTaggingResponse
    ](
      "putStorageLensConfigurationTagging",
      api.putStorageLensConfigurationTagging
    )(request.buildAwsValue())
      .map(
        zio.aws.s3control.model.PutStorageLensConfigurationTaggingResponse.wrap
      )
      .provideEnvironment(r)
    def getAccessPointConfigurationForObjectLambda(
        request: zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest
    ): IO[
      AwsError,
      zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccessPointConfigurationForObjectLambdaRequest,
      GetAccessPointConfigurationForObjectLambdaResponse
    ](
      "getAccessPointConfigurationForObjectLambda",
      api.getAccessPointConfigurationForObjectLambda
    )(request.buildAwsValue())
      .map(
        zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse.wrap
      )
      .provideEnvironment(r)
  }
  def putBucketPolicy(
      request: zio.aws.s3control.model.PutBucketPolicyRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketPolicy(request))
  def getBucketPolicy(
      request: zio.aws.s3control.model.GetBucketPolicyRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetBucketPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketPolicy(request))
  def createMultiRegionAccessPoint(
      request: zio.aws.s3control.model.CreateMultiRegionAccessPointRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.CreateMultiRegionAccessPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMultiRegionAccessPoint(request))
  def describeJob(request: zio.aws.s3control.model.DescribeJobRequest): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.DescribeJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJob(request))
  def getBucket(request: zio.aws.s3control.model.GetBucketRequest): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetBucketResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucket(request))
  def deleteAccessPointPolicy(
      request: zio.aws.s3control.model.DeleteAccessPointPolicyRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccessPointPolicy(request))
  def putBucketLifecycleConfiguration(
      request: zio.aws.s3control.model.PutBucketLifecycleConfigurationRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketLifecycleConfiguration(request))
  def createAccessPoint(
      request: zio.aws.s3control.model.CreateAccessPointRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.CreateAccessPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccessPoint(request))
  def deleteBucketPolicy(
      request: zio.aws.s3control.model.DeleteBucketPolicyRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketPolicy(request))
  def getAccessPointPolicyStatusForObjectLambda(
      request: zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessPointPolicyStatusForObjectLambda(request))
  def getBucketLifecycleConfiguration(
      request: zio.aws.s3control.model.GetBucketLifecycleConfigurationRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketLifecycleConfiguration(request))
  def deleteJobTagging(
      request: zio.aws.s3control.model.DeleteJobTaggingRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.DeleteJobTaggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteJobTagging(request))
  def deleteBucketLifecycleConfiguration(
      request: zio.aws.s3control.model.DeleteBucketLifecycleConfigurationRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketLifecycleConfiguration(request))
  def createJob(request: zio.aws.s3control.model.CreateJobRequest): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.CreateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createJob(request))
  def getStorageLensConfiguration(
      request: zio.aws.s3control.model.GetStorageLensConfigurationRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetStorageLensConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStorageLensConfiguration(request))
  def deleteAccessPointPolicyForObjectLambda(
      request: zio.aws.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccessPointPolicyForObjectLambda(request))
  def putAccessPointConfigurationForObjectLambda(
      request: zio.aws.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putAccessPointConfigurationForObjectLambda(request))
  def putAccessPointPolicy(
      request: zio.aws.s3control.model.PutAccessPointPolicyRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putAccessPointPolicy(request))
  def putAccessPointPolicyForObjectLambda(
      request: zio.aws.s3control.model.PutAccessPointPolicyForObjectLambdaRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putAccessPointPolicyForObjectLambda(request))
  def getMultiRegionAccessPoint(
      request: zio.aws.s3control.model.GetMultiRegionAccessPointRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetMultiRegionAccessPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMultiRegionAccessPoint(request))
  def getAccessPoint(
      request: zio.aws.s3control.model.GetAccessPointRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetAccessPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessPoint(request))
  def deleteStorageLensConfigurationTagging(
      request: zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStorageLensConfigurationTagging(request))
  def deleteBucket(
      request: zio.aws.s3control.model.DeleteBucketRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucket(request))
  def createBucket(request: zio.aws.s3control.model.CreateBucketRequest): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.CreateBucketResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBucket(request))
  def updateJobStatus(
      request: zio.aws.s3control.model.UpdateJobStatusRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.UpdateJobStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateJobStatus(request))
  def getBucketTagging(
      request: zio.aws.s3control.model.GetBucketTaggingRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetBucketTaggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketTagging(request))
  def putStorageLensConfiguration(
      request: zio.aws.s3control.model.PutStorageLensConfigurationRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putStorageLensConfiguration(request))
  def putBucketTagging(
      request: zio.aws.s3control.model.PutBucketTaggingRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketTagging(request))
  def deleteBucketTagging(
      request: zio.aws.s3control.model.DeleteBucketTaggingRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketTagging(request))
  def updateJobPriority(
      request: zio.aws.s3control.model.UpdateJobPriorityRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.UpdateJobPriorityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateJobPriority(request))
  def listStorageLensConfigurations(
      request: zio.aws.s3control.model.ListStorageLensConfigurationsRequest
  ): ZStream[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listStorageLensConfigurations(request))
  def listStorageLensConfigurationsPaginated(
      request: zio.aws.s3control.model.ListStorageLensConfigurationsRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.ListStorageLensConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStorageLensConfigurationsPaginated(request))
  def putPublicAccessBlock(
      request: zio.aws.s3control.model.PutPublicAccessBlockRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putPublicAccessBlock(request))
  def getMultiRegionAccessPointPolicy(
      request: zio.aws.s3control.model.GetMultiRegionAccessPointPolicyRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMultiRegionAccessPointPolicy(request))
  def getBucketVersioning(
      request: zio.aws.s3control.model.GetBucketVersioningRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetBucketVersioningResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketVersioning(request))
  def listRegionalBuckets(
      request: zio.aws.s3control.model.ListRegionalBucketsRequest
  ): ZStream[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.RegionalBucket.ReadOnly
  ] = ZStream.serviceWithStream(_.listRegionalBuckets(request))
  def listRegionalBucketsPaginated(
      request: zio.aws.s3control.model.ListRegionalBucketsRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.ListRegionalBucketsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRegionalBucketsPaginated(request))
  def getAccessPointPolicyForObjectLambda(
      request: zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessPointPolicyForObjectLambda(request))
  def getAccessPointForObjectLambda(
      request: zio.aws.s3control.model.GetAccessPointForObjectLambdaRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessPointForObjectLambda(request))
  def listJobs(request: zio.aws.s3control.model.ListJobsRequest): ZStream[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.JobListDescriptor.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobs(request))
  def listJobsPaginated(request: zio.aws.s3control.model.ListJobsRequest): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.ListJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobsPaginated(request))
  def listAccessPointsForObjectLambda(
      request: zio.aws.s3control.model.ListAccessPointsForObjectLambdaRequest
  ): ZStream[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccessPointsForObjectLambda(request))
  def listAccessPointsForObjectLambdaPaginated(
      request: zio.aws.s3control.model.ListAccessPointsForObjectLambdaRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccessPointsForObjectLambdaPaginated(request))
  def putBucketVersioning(
      request: zio.aws.s3control.model.PutBucketVersioningRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketVersioning(request))
  def listMultiRegionAccessPoints(
      request: zio.aws.s3control.model.ListMultiRegionAccessPointsRequest
  ): ZStream[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly
  ] = ZStream.serviceWithStream(_.listMultiRegionAccessPoints(request))
  def listMultiRegionAccessPointsPaginated(
      request: zio.aws.s3control.model.ListMultiRegionAccessPointsRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.ListMultiRegionAccessPointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMultiRegionAccessPointsPaginated(request))
  def getMultiRegionAccessPointPolicyStatus(
      request: zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMultiRegionAccessPointPolicyStatus(request))
  def getPublicAccessBlock(
      request: zio.aws.s3control.model.GetPublicAccessBlockRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetPublicAccessBlockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPublicAccessBlock(request))
  def deleteMultiRegionAccessPoint(
      request: zio.aws.s3control.model.DeleteMultiRegionAccessPointRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMultiRegionAccessPoint(request))
  def getAccessPointPolicyStatus(
      request: zio.aws.s3control.model.GetAccessPointPolicyStatusRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetAccessPointPolicyStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessPointPolicyStatus(request))
  def getStorageLensConfigurationTagging(
      request: zio.aws.s3control.model.GetStorageLensConfigurationTaggingRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStorageLensConfigurationTagging(request))
  def describeMultiRegionAccessPointOperation(
      request: zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMultiRegionAccessPointOperation(request))
  def deleteAccessPointForObjectLambda(
      request: zio.aws.s3control.model.DeleteAccessPointForObjectLambdaRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccessPointForObjectLambda(request))
  def listAccessPoints(
      request: zio.aws.s3control.model.ListAccessPointsRequest
  ): ZStream[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.AccessPoint.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccessPoints(request))
  def listAccessPointsPaginated(
      request: zio.aws.s3control.model.ListAccessPointsRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.ListAccessPointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccessPointsPaginated(request))
  def getAccessPointPolicy(
      request: zio.aws.s3control.model.GetAccessPointPolicyRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetAccessPointPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessPointPolicy(request))
  def deleteStorageLensConfiguration(
      request: zio.aws.s3control.model.DeleteStorageLensConfigurationRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteStorageLensConfiguration(request))
  def createAccessPointForObjectLambda(
      request: zio.aws.s3control.model.CreateAccessPointForObjectLambdaRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccessPointForObjectLambda(request))
  def putJobTagging(
      request: zio.aws.s3control.model.PutJobTaggingRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.putJobTagging(request))
  def deletePublicAccessBlock(
      request: zio.aws.s3control.model.DeletePublicAccessBlockRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePublicAccessBlock(request))
  def deleteAccessPoint(
      request: zio.aws.s3control.model.DeleteAccessPointRequest
  ): ZIO[zio.aws.s3control.S3Control, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccessPoint(request))
  def putMultiRegionAccessPointPolicy(
      request: zio.aws.s3control.model.PutMultiRegionAccessPointPolicyRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putMultiRegionAccessPointPolicy(request))
  def getJobTagging(request: zio.aws.s3control.model.GetJobTaggingRequest): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetJobTaggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJobTagging(request))
  def putStorageLensConfigurationTagging(
      request: zio.aws.s3control.model.PutStorageLensConfigurationTaggingRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.PutStorageLensConfigurationTaggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putStorageLensConfigurationTagging(request))
  def getAccessPointConfigurationForObjectLambda(
      request: zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest
  ): ZIO[
    zio.aws.s3control.S3Control,
    AwsError,
    zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessPointConfigurationForObjectLambda(request))
}
