package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  MinStorageBytesPercentage,
  StorageLensPrefixLevelMaxDepth,
  StorageLensPrefixLevelDelimiter
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SelectionCriteria(
    delimiter: Optional[StorageLensPrefixLevelDelimiter] = Optional.Absent,
    maxDepth: Optional[StorageLensPrefixLevelMaxDepth] = Optional.Absent,
    minStorageBytesPercentage: Optional[MinStorageBytesPercentage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.SelectionCriteria = {
    import SelectionCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.SelectionCriteria
      .builder()
      .optionallyWith(
        delimiter.map(value =>
          StorageLensPrefixLevelDelimiter.unwrap(value): java.lang.String
        )
      )(_.delimiter)
      .optionallyWith(
        maxDepth.map(value =>
          StorageLensPrefixLevelMaxDepth.unwrap(value): Integer
        )
      )(_.maxDepth)
      .optionallyWith(
        minStorageBytesPercentage.map(value =>
          MinStorageBytesPercentage.unwrap(value): java.lang.Double
        )
      )(_.minStorageBytesPercentage)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.SelectionCriteria.ReadOnly =
    zio.aws.s3control.model.SelectionCriteria.wrap(buildAwsValue())
}
object SelectionCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.SelectionCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.SelectionCriteria =
      zio.aws.s3control.model.SelectionCriteria(
        delimiter.map(value => value),
        maxDepth.map(value => value),
        minStorageBytesPercentage.map(value => value)
      )
    def delimiter: Optional[StorageLensPrefixLevelDelimiter]
    def maxDepth: Optional[StorageLensPrefixLevelMaxDepth]
    def minStorageBytesPercentage: Optional[MinStorageBytesPercentage]
    def getDelimiter: ZIO[Any, AwsError, StorageLensPrefixLevelDelimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getMaxDepth: ZIO[Any, AwsError, StorageLensPrefixLevelMaxDepth] =
      AwsError.unwrapOptionField("maxDepth", maxDepth)
    def getMinStorageBytesPercentage
        : ZIO[Any, AwsError, MinStorageBytesPercentage] = AwsError
      .unwrapOptionField("minStorageBytesPercentage", minStorageBytesPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.SelectionCriteria
  ) extends zio.aws.s3control.model.SelectionCriteria.ReadOnly {
    override val delimiter: Optional[StorageLensPrefixLevelDelimiter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.delimiter())
        .map(value =>
          zio.aws.s3control.model.primitives
            .StorageLensPrefixLevelDelimiter(value)
        )
    override val maxDepth: Optional[StorageLensPrefixLevelMaxDepth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDepth())
        .map(value =>
          zio.aws.s3control.model.primitives
            .StorageLensPrefixLevelMaxDepth(value)
        )
    override val minStorageBytesPercentage
        : Optional[MinStorageBytesPercentage] = zio.aws.core.internal
      .optionalFromNullable(impl.minStorageBytesPercentage())
      .map(value =>
        zio.aws.s3control.model.primitives.MinStorageBytesPercentage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.SelectionCriteria
  ): zio.aws.s3control.model.SelectionCriteria.ReadOnly = new Wrapper(impl)
}
