package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  S3BucketArnString,
  NonEmptyMaxLength2048String,
  KmsKeyArnString,
  NonEmptyMaxLength1024String,
  TimeStamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class S3CopyObjectOperation(
    targetResource: Optional[S3BucketArnString] = Optional.Absent,
    cannedAccessControlList: Optional[
      zio.aws.s3control.model.S3CannedAccessControlList
    ] = Optional.Absent,
    accessControlGrants: Optional[Iterable[zio.aws.s3control.model.S3Grant]] =
      Optional.Absent,
    metadataDirective: Optional[zio.aws.s3control.model.S3MetadataDirective] =
      Optional.Absent,
    modifiedSinceConstraint: Optional[TimeStamp] = Optional.Absent,
    newObjectMetadata: Optional[zio.aws.s3control.model.S3ObjectMetadata] =
      Optional.Absent,
    newObjectTagging: Optional[Iterable[zio.aws.s3control.model.S3Tag]] =
      Optional.Absent,
    redirectLocation: Optional[NonEmptyMaxLength2048String] = Optional.Absent,
    requesterPays: Optional[Boolean] = Optional.Absent,
    storageClass: Optional[zio.aws.s3control.model.S3StorageClass] =
      Optional.Absent,
    unModifiedSinceConstraint: Optional[TimeStamp] = Optional.Absent,
    sseAwsKmsKeyId: Optional[KmsKeyArnString] = Optional.Absent,
    targetKeyPrefix: Optional[NonEmptyMaxLength1024String] = Optional.Absent,
    objectLockLegalHoldStatus: Optional[
      zio.aws.s3control.model.S3ObjectLockLegalHoldStatus
    ] = Optional.Absent,
    objectLockMode: Optional[zio.aws.s3control.model.S3ObjectLockMode] =
      Optional.Absent,
    objectLockRetainUntilDate: Optional[TimeStamp] = Optional.Absent,
    bucketKeyEnabled: Optional[Boolean] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3control.model.S3ChecksumAlgorithm] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation = {
    import S3CopyObjectOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation
      .builder()
      .optionallyWith(
        targetResource.map(value =>
          S3BucketArnString.unwrap(value): java.lang.String
        )
      )(_.targetResource)
      .optionallyWith(cannedAccessControlList.map(value => value.unwrap))(
        _.cannedAccessControlList
      )
      .optionallyWith(
        accessControlGrants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessControlGrants)
      .optionallyWith(metadataDirective.map(value => value.unwrap))(
        _.metadataDirective
      )
      .optionallyWith(
        modifiedSinceConstraint.map(value => TimeStamp.unwrap(value): Instant)
      )(_.modifiedSinceConstraint)
      .optionallyWith(newObjectMetadata.map(value => value.buildAwsValue()))(
        _.newObjectMetadata
      )
      .optionallyWith(
        newObjectTagging.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.newObjectTagging)
      .optionallyWith(
        redirectLocation.map(value =>
          NonEmptyMaxLength2048String.unwrap(value): java.lang.String
        )
      )(_.redirectLocation)
      .optionallyWith(requesterPays.map(value => value: java.lang.Boolean))(
        _.requesterPays
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        unModifiedSinceConstraint.map(value => TimeStamp.unwrap(value): Instant)
      )(_.unModifiedSinceConstraint)
      .optionallyWith(
        sseAwsKmsKeyId.map(value =>
          KmsKeyArnString.unwrap(value): java.lang.String
        )
      )(_.sseAwsKmsKeyId)
      .optionallyWith(
        targetKeyPrefix.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.targetKeyPrefix)
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(
        objectLockRetainUntilDate.map(value => TimeStamp.unwrap(value): Instant)
      )(_.objectLockRetainUntilDate)
      .optionallyWith(bucketKeyEnabled.map(value => value: java.lang.Boolean))(
        _.bucketKeyEnabled
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly =
    zio.aws.s3control.model.S3CopyObjectOperation.wrap(buildAwsValue())
}
object S3CopyObjectOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3CopyObjectOperation =
      zio.aws.s3control.model.S3CopyObjectOperation(
        targetResource.map(value => value),
        cannedAccessControlList.map(value => value),
        accessControlGrants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metadataDirective.map(value => value),
        modifiedSinceConstraint.map(value => value),
        newObjectMetadata.map(value => value.asEditable),
        newObjectTagging.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        redirectLocation.map(value => value),
        requesterPays.map(value => value),
        storageClass.map(value => value),
        unModifiedSinceConstraint.map(value => value),
        sseAwsKmsKeyId.map(value => value),
        targetKeyPrefix.map(value => value),
        objectLockLegalHoldStatus.map(value => value),
        objectLockMode.map(value => value),
        objectLockRetainUntilDate.map(value => value),
        bucketKeyEnabled.map(value => value),
        checksumAlgorithm.map(value => value)
      )
    def targetResource: Optional[S3BucketArnString]
    def cannedAccessControlList
        : Optional[zio.aws.s3control.model.S3CannedAccessControlList]
    def accessControlGrants
        : Optional[List[zio.aws.s3control.model.S3Grant.ReadOnly]]
    def metadataDirective: Optional[zio.aws.s3control.model.S3MetadataDirective]
    def modifiedSinceConstraint: Optional[TimeStamp]
    def newObjectMetadata
        : Optional[zio.aws.s3control.model.S3ObjectMetadata.ReadOnly]
    def newObjectTagging: Optional[List[zio.aws.s3control.model.S3Tag.ReadOnly]]
    def redirectLocation: Optional[NonEmptyMaxLength2048String]
    def requesterPays: Optional[Boolean]
    def storageClass: Optional[zio.aws.s3control.model.S3StorageClass]
    def unModifiedSinceConstraint: Optional[TimeStamp]
    def sseAwsKmsKeyId: Optional[KmsKeyArnString]
    def targetKeyPrefix: Optional[NonEmptyMaxLength1024String]
    def objectLockLegalHoldStatus
        : Optional[zio.aws.s3control.model.S3ObjectLockLegalHoldStatus]
    def objectLockMode: Optional[zio.aws.s3control.model.S3ObjectLockMode]
    def objectLockRetainUntilDate: Optional[TimeStamp]
    def bucketKeyEnabled: Optional[Boolean]
    def checksumAlgorithm: Optional[zio.aws.s3control.model.S3ChecksumAlgorithm]
    def getTargetResource: ZIO[Any, AwsError, S3BucketArnString] =
      AwsError.unwrapOptionField("targetResource", targetResource)
    def getCannedAccessControlList: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3CannedAccessControlList
    ] = AwsError.unwrapOptionField(
      "cannedAccessControlList",
      cannedAccessControlList
    )
    def getAccessControlGrants
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.S3Grant.ReadOnly]] =
      AwsError.unwrapOptionField("accessControlGrants", accessControlGrants)
    def getMetadataDirective
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3MetadataDirective] =
      AwsError.unwrapOptionField("metadataDirective", metadataDirective)
    def getModifiedSinceConstraint: ZIO[Any, AwsError, TimeStamp] = AwsError
      .unwrapOptionField("modifiedSinceConstraint", modifiedSinceConstraint)
    def getNewObjectMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3ObjectMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("newObjectMetadata", newObjectMetadata)
    def getNewObjectTagging
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      AwsError.unwrapOptionField("newObjectTagging", newObjectTagging)
    def getRedirectLocation: ZIO[Any, AwsError, NonEmptyMaxLength2048String] =
      AwsError.unwrapOptionField("redirectLocation", redirectLocation)
    def getRequesterPays: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterPays", requesterPays)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getUnModifiedSinceConstraint: ZIO[Any, AwsError, TimeStamp] = AwsError
      .unwrapOptionField("unModifiedSinceConstraint", unModifiedSinceConstraint)
    def getSseAwsKmsKeyId: ZIO[Any, AwsError, KmsKeyArnString] =
      AwsError.unwrapOptionField("sseAwsKmsKeyId", sseAwsKmsKeyId)
    def getTargetKeyPrefix: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("targetKeyPrefix", targetKeyPrefix)
    def getObjectLockLegalHoldStatus: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3ObjectLockLegalHoldStatus
    ] = AwsError.unwrapOptionField(
      "objectLockLegalHoldStatus",
      objectLockLegalHoldStatus
    )
    def getObjectLockMode
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockMode)
    def getObjectLockRetainUntilDate: ZIO[Any, AwsError, TimeStamp] = AwsError
      .unwrapOptionField("objectLockRetainUntilDate", objectLockRetainUntilDate)
    def getBucketKeyEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation
  ) extends zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly {
    override val targetResource: Optional[S3BucketArnString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetResource())
        .map(value =>
          zio.aws.s3control.model.primitives.S3BucketArnString(value)
        )
    override val cannedAccessControlList
        : Optional[zio.aws.s3control.model.S3CannedAccessControlList] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cannedAccessControlList())
        .map(value =>
          zio.aws.s3control.model.S3CannedAccessControlList.wrap(value)
        )
    override val accessControlGrants
        : Optional[List[zio.aws.s3control.model.S3Grant.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlGrants())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.S3Grant.wrap(item)
          }.toList
        )
    override val metadataDirective
        : Optional[zio.aws.s3control.model.S3MetadataDirective] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataDirective())
        .map(value => zio.aws.s3control.model.S3MetadataDirective.wrap(value))
    override val modifiedSinceConstraint: Optional[TimeStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedSinceConstraint())
        .map(value => zio.aws.s3control.model.primitives.TimeStamp(value))
    override val newObjectMetadata
        : Optional[zio.aws.s3control.model.S3ObjectMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newObjectMetadata())
        .map(value => zio.aws.s3control.model.S3ObjectMetadata.wrap(value))
    override val newObjectTagging
        : Optional[List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newObjectTagging())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.S3Tag.wrap(item)
          }.toList
        )
    override val redirectLocation: Optional[NonEmptyMaxLength2048String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redirectLocation())
        .map(value =>
          zio.aws.s3control.model.primitives.NonEmptyMaxLength2048String(value)
        )
    override val requesterPays: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterPays())
      .map(value => value: Boolean)
    override val storageClass
        : Optional[zio.aws.s3control.model.S3StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3control.model.S3StorageClass.wrap(value))
    override val unModifiedSinceConstraint: Optional[TimeStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unModifiedSinceConstraint())
        .map(value => zio.aws.s3control.model.primitives.TimeStamp(value))
    override val sseAwsKmsKeyId: Optional[KmsKeyArnString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseAwsKmsKeyId())
        .map(value => zio.aws.s3control.model.primitives.KmsKeyArnString(value))
    override val targetKeyPrefix: Optional[NonEmptyMaxLength1024String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetKeyPrefix())
        .map(value =>
          zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
        )
    override val objectLockLegalHoldStatus
        : Optional[zio.aws.s3control.model.S3ObjectLockLegalHoldStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockLegalHoldStatus())
        .map(value =>
          zio.aws.s3control.model.S3ObjectLockLegalHoldStatus.wrap(value)
        )
    override val objectLockMode
        : Optional[zio.aws.s3control.model.S3ObjectLockMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockMode())
        .map(value => zio.aws.s3control.model.S3ObjectLockMode.wrap(value))
    override val objectLockRetainUntilDate: Optional[TimeStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockRetainUntilDate())
        .map(value => zio.aws.s3control.model.primitives.TimeStamp(value))
    override val bucketKeyEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketKeyEnabled())
      .map(value => value: Boolean)
    override val checksumAlgorithm
        : Optional[zio.aws.s3control.model.S3ChecksumAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumAlgorithm())
        .map(value => zio.aws.s3control.model.S3ChecksumAlgorithm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation
  ): zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly = new Wrapper(impl)
}
