package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ObjectLambdaTransformationConfiguration(
    actions: Iterable[
      zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction
    ],
    contentTransformation: zio.aws.s3control.model.ObjectLambdaContentTransformation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfiguration = {
    import ObjectLambdaTransformationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfiguration
      .builder()
      .actionsWithStrings(actions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .contentTransformation(contentTransformation.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.ObjectLambdaTransformationConfiguration.ReadOnly =
    zio.aws.s3control.model.ObjectLambdaTransformationConfiguration
      .wrap(buildAwsValue())
}
object ObjectLambdaTransformationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.ObjectLambdaTransformationConfiguration =
      zio.aws.s3control.model.ObjectLambdaTransformationConfiguration(
        actions,
        contentTransformation.asEditable
      )
    def actions: List[
      zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction
    ]
    def contentTransformation
        : zio.aws.s3control.model.ObjectLambdaContentTransformation.ReadOnly
    def getActions: ZIO[Any, Nothing, List[
      zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction
    ]] = ZIO.succeed(actions)
    def getContentTransformation: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.ObjectLambdaContentTransformation.ReadOnly
    ] = ZIO.succeed(contentTransformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfiguration
  ) extends zio.aws.s3control.model.ObjectLambdaTransformationConfiguration.ReadOnly {
    override val actions: List[
      zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction
    ] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.s3control.model.ObjectLambdaTransformationConfigurationAction
          .wrap(item)
      }
      .toList
    override val contentTransformation
        : zio.aws.s3control.model.ObjectLambdaContentTransformation.ReadOnly =
      zio.aws.s3control.model.ObjectLambdaContentTransformation
        .wrap(impl.contentTransformation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfiguration
  ): zio.aws.s3control.model.ObjectLambdaTransformationConfiguration.ReadOnly =
    new Wrapper(impl)
}
