package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait NetworkOrigin {
  def unwrap: software.amazon.awssdk.services.s3control.model.NetworkOrigin
}
object NetworkOrigin {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.NetworkOrigin
  ): zio.aws.s3control.model.NetworkOrigin = value match {
    case software.amazon.awssdk.services.s3control.model.NetworkOrigin.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.NetworkOrigin.INTERNET =>
      val r = Internet
      r
    case software.amazon.awssdk.services.s3control.model.NetworkOrigin.VPC =>
      val r = VPC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.NetworkOrigin {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.NetworkOrigin =
      software.amazon.awssdk.services.s3control.model.NetworkOrigin.UNKNOWN_TO_SDK_VERSION
  }
  case object Internet extends zio.aws.s3control.model.NetworkOrigin {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.NetworkOrigin =
      software.amazon.awssdk.services.s3control.model.NetworkOrigin.INTERNET
  }
  case object VPC extends zio.aws.s3control.model.NetworkOrigin {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.NetworkOrigin =
      software.amazon.awssdk.services.s3control.model.NetworkOrigin.VPC
  }
}
