package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetStorageLensConfigurationTaggingResponse(
    tags: Optional[Iterable[zio.aws.s3control.model.StorageLensTag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingResponse = {
    import GetStorageLensConfigurationTaggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse.ReadOnly =
    zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse
      .wrap(buildAwsValue())
}
object GetStorageLensConfigurationTaggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse =
      zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Optional[List[zio.aws.s3control.model.StorageLensTag.ReadOnly]]
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.StorageLensTag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingResponse
  ) extends zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse.ReadOnly {
    override val tags
        : Optional[List[zio.aws.s3control.model.StorageLensTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.StorageLensTag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingResponse
  ): zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse.ReadOnly =
    new Wrapper(impl)
}
