package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetPublicAccessBlockResponse(
    publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse = {
    import GetPublicAccessBlockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse
      .builder()
      .optionallyWith(
        publicAccessBlockConfiguration.map(value => value.buildAwsValue())
      )(_.publicAccessBlockConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetPublicAccessBlockResponse.ReadOnly =
    zio.aws.s3control.model.GetPublicAccessBlockResponse.wrap(buildAwsValue())
}
object GetPublicAccessBlockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetPublicAccessBlockResponse =
      zio.aws.s3control.model.GetPublicAccessBlockResponse(
        publicAccessBlockConfiguration.map(value => value.asEditable)
      )
    def publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ]
    def getPublicAccessBlockConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicAccessBlockConfiguration",
      publicAccessBlockConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse
  ) extends zio.aws.s3control.model.GetPublicAccessBlockResponse.ReadOnly {
    override val publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.publicAccessBlockConfiguration())
      .map(value =>
        zio.aws.s3control.model.PublicAccessBlockConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse
  ): zio.aws.s3control.model.GetPublicAccessBlockResponse.ReadOnly =
    new Wrapper(impl)
}
