package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{JobId, AccountId}
import scala.jdk.CollectionConverters.*
final case class GetJobTaggingRequest(accountId: AccountId, jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest = {
    import GetJobTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GetJobTaggingRequest.ReadOnly =
    zio.aws.s3control.model.GetJobTaggingRequest.wrap(buildAwsValue())
}
object GetJobTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetJobTaggingRequest =
      zio.aws.s3control.model.GetJobTaggingRequest(accountId, jobId)
    def accountId: AccountId
    def jobId: JobId
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest
  ) extends zio.aws.s3control.model.GetJobTaggingRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val jobId: JobId =
      zio.aws.s3control.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest
  ): zio.aws.s3control.model.GetJobTaggingRequest.ReadOnly = new Wrapper(impl)
}
