package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait Format {
  def unwrap: software.amazon.awssdk.services.s3control.model.Format
}
object Format {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.Format
  ): zio.aws.s3control.model.Format = value match {
    case software.amazon.awssdk.services.s3control.model.Format.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.Format.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.s3control.model.Format.PARQUET =>
      val r = Parquet
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3control.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.Format =
      software.amazon.awssdk.services.s3control.model.Format.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.s3control.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.Format =
      software.amazon.awssdk.services.s3control.model.Format.CSV
  }
  case object Parquet extends zio.aws.s3control.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.Format =
      software.amazon.awssdk.services.s3control.model.Format.PARQUET
  }
}
