package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{AsyncRequestTokenARN, AccountId}
import scala.jdk.CollectionConverters.*
final case class DescribeMultiRegionAccessPointOperationRequest(
    accountId: AccountId,
    requestTokenARN: AsyncRequestTokenARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest = {
    import DescribeMultiRegionAccessPointOperationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .requestTokenARN(
        AsyncRequestTokenARN.unwrap(requestTokenARN): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationRequest.ReadOnly =
    zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationRequest
      .wrap(buildAwsValue())
}
object DescribeMultiRegionAccessPointOperationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationRequest =
      zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationRequest(
        accountId,
        requestTokenARN
      )
    def accountId: AccountId
    def requestTokenARN: AsyncRequestTokenARN
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getRequestTokenARN: ZIO[Any, Nothing, AsyncRequestTokenARN] =
      ZIO.succeed(requestTokenARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest
  ) extends zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val requestTokenARN: AsyncRequestTokenARN =
      zio.aws.s3control.model.primitives
        .AsyncRequestTokenARN(impl.requestTokenARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest
  ): zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationRequest.ReadOnly =
    new Wrapper(impl)
}
