package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{AccountId, ConfigId}
import scala.jdk.CollectionConverters.*
final case class DeleteStorageLensConfigurationRequest(
    configId: ConfigId,
    accountId: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationRequest = {
    import DeleteStorageLensConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationRequest
      .builder()
      .configId(ConfigId.unwrap(configId): java.lang.String)
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.DeleteStorageLensConfigurationRequest.ReadOnly =
    zio.aws.s3control.model.DeleteStorageLensConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteStorageLensConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.DeleteStorageLensConfigurationRequest =
      zio.aws.s3control.model
        .DeleteStorageLensConfigurationRequest(configId, accountId)
    def configId: ConfigId
    def accountId: AccountId
    def getConfigId: ZIO[Any, Nothing, ConfigId] = ZIO.succeed(configId)
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationRequest
  ) extends zio.aws.s3control.model.DeleteStorageLensConfigurationRequest.ReadOnly {
    override val configId: ConfigId =
      zio.aws.s3control.model.primitives.ConfigId(impl.configId())
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationRequest
  ): zio.aws.s3control.model.DeleteStorageLensConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
