package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{
  BucketName,
  AccessPointName,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class CreateAccessPointRequest(
    accountId: AccountId,
    name: AccessPointName,
    bucket: BucketName,
    vpcConfiguration: Optional[zio.aws.s3control.model.VpcConfiguration] =
      Optional.Absent,
    publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest = {
    import CreateAccessPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .name(AccessPointName.unwrap(name): java.lang.String)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        publicAccessBlockConfiguration.map(value => value.buildAwsValue())
      )(_.publicAccessBlockConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.CreateAccessPointRequest.ReadOnly =
    zio.aws.s3control.model.CreateAccessPointRequest.wrap(buildAwsValue())
}
object CreateAccessPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.CreateAccessPointRequest =
      zio.aws.s3control.model.CreateAccessPointRequest(
        accountId,
        name,
        bucket,
        vpcConfiguration.map(value => value.asEditable),
        publicAccessBlockConfiguration.map(value => value.asEditable)
      )
    def accountId: AccountId
    def name: AccessPointName
    def bucket: BucketName
    def vpcConfiguration
        : Optional[zio.aws.s3control.model.VpcConfiguration.ReadOnly]
    def publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, AccessPointName] = ZIO.succeed(name)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getPublicAccessBlockConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicAccessBlockConfiguration",
      publicAccessBlockConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest
  ) extends zio.aws.s3control.model.CreateAccessPointRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val name: AccessPointName =
      zio.aws.s3control.model.primitives.AccessPointName(impl.name())
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val vpcConfiguration
        : Optional[zio.aws.s3control.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.s3control.model.VpcConfiguration.wrap(value))
    override val publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.publicAccessBlockConfiguration())
      .map(value =>
        zio.aws.s3control.model.PublicAccessBlockConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest
  ): zio.aws.s3control.model.CreateAccessPointRequest.ReadOnly = new Wrapper(
    impl
  )
}
