package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{JobStatusUpdateReason, JobId}
import scala.jdk.CollectionConverters.*
final case class UpdateJobStatusResponse(
    jobId: Option[JobId] = None,
    status: Option[zio.aws.s3control.model.JobStatus] = None,
    statusUpdateReason: Option[JobStatusUpdateReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse = {
    import UpdateJobStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusUpdateReason.map(value =>
          JobStatusUpdateReason.unwrap(value): java.lang.String
        )
      )(_.statusUpdateReason)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.UpdateJobStatusResponse.ReadOnly =
    zio.aws.s3control.model.UpdateJobStatusResponse.wrap(buildAwsValue())
}
object UpdateJobStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.UpdateJobStatusResponse =
      zio.aws.s3control.model.UpdateJobStatusResponse(
        jobId.map(value => value),
        status.map(value => value),
        statusUpdateReason.map(value => value)
      )
    def jobId: Option[JobId]
    def status: Option[zio.aws.s3control.model.JobStatus]
    def statusUpdateReason: Option[JobStatusUpdateReason]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getStatus: ZIO[Any, AwsError, zio.aws.s3control.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusUpdateReason: ZIO[Any, AwsError, JobStatusUpdateReason] =
      AwsError.unwrapOptionField("statusUpdateReason", statusUpdateReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse
  ) extends zio.aws.s3control.model.UpdateJobStatusResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.s3control.model.primitives.JobId(value))
    override val status: Option[zio.aws.s3control.model.JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.s3control.model.JobStatus.wrap(value))
    override val statusUpdateReason: Option[JobStatusUpdateReason] = scala
      .Option(impl.statusUpdateReason())
      .map(value =>
        zio.aws.s3control.model.primitives.JobStatusUpdateReason(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse
  ): zio.aws.s3control.model.UpdateJobStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
