package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StorageLensDataExport(
    s3BucketDestination: Option[zio.aws.s3control.model.S3BucketDestination] =
      None,
    cloudWatchMetrics: Option[zio.aws.s3control.model.CloudWatchMetrics] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.StorageLensDataExport = {
    import StorageLensDataExport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.StorageLensDataExport
      .builder()
      .optionallyWith(s3BucketDestination.map(value => value.buildAwsValue()))(
        _.s3BucketDestination
      )
      .optionallyWith(cloudWatchMetrics.map(value => value.buildAwsValue()))(
        _.cloudWatchMetrics
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.StorageLensDataExport.ReadOnly =
    zio.aws.s3control.model.StorageLensDataExport.wrap(buildAwsValue())
}
object StorageLensDataExport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.StorageLensDataExport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.StorageLensDataExport =
      zio.aws.s3control.model.StorageLensDataExport(
        s3BucketDestination.map(value => value.asEditable),
        cloudWatchMetrics.map(value => value.asEditable)
      )
    def s3BucketDestination
        : Option[zio.aws.s3control.model.S3BucketDestination.ReadOnly]
    def cloudWatchMetrics
        : Option[zio.aws.s3control.model.CloudWatchMetrics.ReadOnly]
    def getS3BucketDestination: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3BucketDestination.ReadOnly
    ] = AwsError.unwrapOptionField("s3BucketDestination", s3BucketDestination)
    def getCloudWatchMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.CloudWatchMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchMetrics", cloudWatchMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.StorageLensDataExport
  ) extends zio.aws.s3control.model.StorageLensDataExport.ReadOnly {
    override val s3BucketDestination
        : Option[zio.aws.s3control.model.S3BucketDestination.ReadOnly] = scala
      .Option(impl.s3BucketDestination())
      .map(value => zio.aws.s3control.model.S3BucketDestination.wrap(value))
    override val cloudWatchMetrics
        : Option[zio.aws.s3control.model.CloudWatchMetrics.ReadOnly] = scala
      .Option(impl.cloudWatchMetrics())
      .map(value => zio.aws.s3control.model.CloudWatchMetrics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.StorageLensDataExport
  ): zio.aws.s3control.model.StorageLensDataExport.ReadOnly = new Wrapper(impl)
}
