package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3SetObjectAclOperation(
    accessControlPolicy: Option[zio.aws.s3control.model.S3AccessControlPolicy] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3SetObjectAclOperation = {
    import S3SetObjectAclOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3SetObjectAclOperation
      .builder()
      .optionallyWith(accessControlPolicy.map(value => value.buildAwsValue()))(
        _.accessControlPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3SetObjectAclOperation.ReadOnly =
    zio.aws.s3control.model.S3SetObjectAclOperation.wrap(buildAwsValue())
}
object S3SetObjectAclOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3SetObjectAclOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3SetObjectAclOperation =
      zio.aws.s3control.model.S3SetObjectAclOperation(
        accessControlPolicy.map(value => value.asEditable)
      )
    def accessControlPolicy
        : Option[zio.aws.s3control.model.S3AccessControlPolicy.ReadOnly]
    def getAccessControlPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3AccessControlPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("accessControlPolicy", accessControlPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3SetObjectAclOperation
  ) extends zio.aws.s3control.model.S3SetObjectAclOperation.ReadOnly {
    override val accessControlPolicy
        : Option[zio.aws.s3control.model.S3AccessControlPolicy.ReadOnly] = scala
      .Option(impl.accessControlPolicy())
      .map(value => zio.aws.s3control.model.S3AccessControlPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3SetObjectAclOperation
  ): zio.aws.s3control.model.S3SetObjectAclOperation.ReadOnly = new Wrapper(
    impl
  )
}
