package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.s3control.model.primitives.{
  TimeStamp,
  S3ContentLength,
  MaxLength1024String,
  NonEmptyMaxLength1024String
}
import scala.jdk.CollectionConverters.*
final case class S3ObjectMetadata(
    cacheControl: Option[NonEmptyMaxLength1024String] = None,
    contentDisposition: Option[NonEmptyMaxLength1024String] = None,
    contentEncoding: Option[NonEmptyMaxLength1024String] = None,
    contentLanguage: Option[NonEmptyMaxLength1024String] = None,
    userMetadata: Option[
      Map[NonEmptyMaxLength1024String, MaxLength1024String]
    ] = None,
    contentLength: Option[S3ContentLength] = None,
    contentMD5: Option[NonEmptyMaxLength1024String] = None,
    contentType: Option[NonEmptyMaxLength1024String] = None,
    httpExpiresDate: Option[TimeStamp] = None,
    requesterCharged: Option[Boolean] = None,
    sseAlgorithm: Option[zio.aws.s3control.model.S3SSEAlgorithm] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3ObjectMetadata = {
    import S3ObjectMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3ObjectMetadata
      .builder()
      .optionallyWith(
        cacheControl.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.cacheControl)
      .optionallyWith(
        contentDisposition.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.contentDisposition)
      .optionallyWith(
        contentEncoding.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.contentEncoding)
      .optionallyWith(
        contentLanguage.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.contentLanguage)
      .optionallyWith(
        userMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyMaxLength1024String.unwrap(
                key
              ): java.lang.String) -> (MaxLength1024String.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.userMetadata)
      .optionallyWith(
        contentLength.map(value =>
          S3ContentLength.unwrap(value): java.lang.Long
        )
      )(_.contentLength)
      .optionallyWith(
        contentMD5.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.contentMD5)
      .optionallyWith(
        contentType.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        httpExpiresDate.map(value => TimeStamp.unwrap(value): Instant)
      )(_.httpExpiresDate)
      .optionallyWith(requesterCharged.map(value => value: java.lang.Boolean))(
        _.requesterCharged
      )
      .optionallyWith(sseAlgorithm.map(value => value.unwrap))(_.sseAlgorithm)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3ObjectMetadata.ReadOnly =
    zio.aws.s3control.model.S3ObjectMetadata.wrap(buildAwsValue())
}
object S3ObjectMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3ObjectMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3ObjectMetadata =
      zio.aws.s3control.model.S3ObjectMetadata(
        cacheControl.map(value => value),
        contentDisposition.map(value => value),
        contentEncoding.map(value => value),
        contentLanguage.map(value => value),
        userMetadata.map(value => value),
        contentLength.map(value => value),
        contentMD5.map(value => value),
        contentType.map(value => value),
        httpExpiresDate.map(value => value),
        requesterCharged.map(value => value),
        sseAlgorithm.map(value => value)
      )
    def cacheControl: Option[NonEmptyMaxLength1024String]
    def contentDisposition: Option[NonEmptyMaxLength1024String]
    def contentEncoding: Option[NonEmptyMaxLength1024String]
    def contentLanguage: Option[NonEmptyMaxLength1024String]
    def userMetadata
        : Option[Map[NonEmptyMaxLength1024String, MaxLength1024String]]
    def contentLength: Option[S3ContentLength]
    def contentMD5: Option[NonEmptyMaxLength1024String]
    def contentType: Option[NonEmptyMaxLength1024String]
    def httpExpiresDate: Option[TimeStamp]
    def requesterCharged: Option[Boolean]
    def sseAlgorithm: Option[zio.aws.s3control.model.S3SSEAlgorithm]
    def getCacheControl: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getContentDisposition: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("contentDisposition", contentDisposition)
    def getContentEncoding: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getContentLanguage: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguage)
    def getUserMetadata: ZIO[Any, AwsError, Map[
      NonEmptyMaxLength1024String,
      MaxLength1024String
    ]] = AwsError.unwrapOptionField("userMetadata", userMetadata)
    def getContentLength: ZIO[Any, AwsError, S3ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getContentMD5: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getContentType: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getHttpExpiresDate: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("httpExpiresDate", httpExpiresDate)
    def getRequesterCharged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterCharged", requesterCharged)
    def getSseAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3SSEAlgorithm] =
      AwsError.unwrapOptionField("sseAlgorithm", sseAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3ObjectMetadata
  ) extends zio.aws.s3control.model.S3ObjectMetadata.ReadOnly {
    override val cacheControl: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.cacheControl())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
    override val contentDisposition: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.contentDisposition())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
    override val contentEncoding: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.contentEncoding())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
    override val contentLanguage: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.contentLanguage())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
    override val userMetadata
        : Option[Map[NonEmptyMaxLength1024String, MaxLength1024String]] = scala
      .Option(impl.userMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(
              key
            ) -> zio.aws.s3control.model.primitives.MaxLength1024String(value)
          })
          .toMap
      )
    override val contentLength: Option[S3ContentLength] = scala
      .Option(impl.contentLength())
      .map(value => zio.aws.s3control.model.primitives.S3ContentLength(value))
    override val contentMD5: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.contentMD5())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
    override val contentType: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.contentType())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
    override val httpExpiresDate: Option[TimeStamp] = scala
      .Option(impl.httpExpiresDate())
      .map(value => zio.aws.s3control.model.primitives.TimeStamp(value))
    override val requesterCharged: Option[Boolean] =
      scala.Option(impl.requesterCharged()).map(value => value: Boolean)
    override val sseAlgorithm: Option[zio.aws.s3control.model.S3SSEAlgorithm] =
      scala
        .Option(impl.sseAlgorithm())
        .map(value => zio.aws.s3control.model.S3SSEAlgorithm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3ObjectMetadata
  ): zio.aws.s3control.model.S3ObjectMetadata.ReadOnly = new Wrapper(impl)
}
