package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait S3ObjectLockMode {
  def unwrap: software.amazon.awssdk.services.s3control.model.S3ObjectLockMode
}
object S3ObjectLockMode {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.S3ObjectLockMode
  ): zio.aws.s3control.model.S3ObjectLockMode = value match {
    case software.amazon.awssdk.services.s3control.model.S3ObjectLockMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.S3ObjectLockMode.COMPLIANCE =>
      val r = COMPLIANCE
      r
    case software.amazon.awssdk.services.s3control.model.S3ObjectLockMode.GOVERNANCE =>
      val r = GOVERNANCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.S3ObjectLockMode {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3ObjectLockMode =
      software.amazon.awssdk.services.s3control.model.S3ObjectLockMode.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLIANCE extends zio.aws.s3control.model.S3ObjectLockMode {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3ObjectLockMode =
      software.amazon.awssdk.services.s3control.model.S3ObjectLockMode.COMPLIANCE
  }
  case object GOVERNANCE extends zio.aws.s3control.model.S3ObjectLockMode {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3ObjectLockMode =
      software.amazon.awssdk.services.s3control.model.S3ObjectLockMode.GOVERNANCE
  }
}
