package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3Grant(
    grantee: Option[zio.aws.s3control.model.S3Grantee] = None,
    permission: Option[zio.aws.s3control.model.S3Permission] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3Grant = {
    import S3Grant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3Grant
      .builder()
      .optionallyWith(grantee.map(value => value.buildAwsValue()))(_.grantee)
      .optionallyWith(permission.map(value => value.unwrap))(_.permission)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3Grant.ReadOnly =
    zio.aws.s3control.model.S3Grant.wrap(buildAwsValue())
}
object S3Grant {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3control.model.S3Grant] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3Grant =
      zio.aws.s3control.model.S3Grant(
        grantee.map(value => value.asEditable),
        permission.map(value => value)
      )
    def grantee: Option[zio.aws.s3control.model.S3Grantee.ReadOnly]
    def permission: Option[zio.aws.s3control.model.S3Permission]
    def getGrantee
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3Grantee.ReadOnly] =
      AwsError.unwrapOptionField("grantee", grantee)
    def getPermission
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3Permission] =
      AwsError.unwrapOptionField("permission", permission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3Grant
  ) extends zio.aws.s3control.model.S3Grant.ReadOnly {
    override val grantee: Option[zio.aws.s3control.model.S3Grantee.ReadOnly] =
      scala
        .Option(impl.grantee())
        .map(value => zio.aws.s3control.model.S3Grantee.wrap(value))
    override val permission: Option[zio.aws.s3control.model.S3Permission] =
      scala
        .Option(impl.permission())
        .map(value => zio.aws.s3control.model.S3Permission.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3Grant
  ): zio.aws.s3control.model.S3Grant.ReadOnly = new Wrapper(impl)
}
