package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.s3control.model.primitives.{
  S3BucketArnString,
  NonEmptyMaxLength2048String,
  KmsKeyArnString,
  NonEmptyMaxLength1024String,
  TimeStamp
}
import scala.jdk.CollectionConverters.*
final case class S3CopyObjectOperation(
    targetResource: Option[S3BucketArnString] = None,
    cannedAccessControlList: Option[
      zio.aws.s3control.model.S3CannedAccessControlList
    ] = None,
    accessControlGrants: Option[Iterable[zio.aws.s3control.model.S3Grant]] =
      None,
    metadataDirective: Option[zio.aws.s3control.model.S3MetadataDirective] =
      None,
    modifiedSinceConstraint: Option[TimeStamp] = None,
    newObjectMetadata: Option[zio.aws.s3control.model.S3ObjectMetadata] = None,
    newObjectTagging: Option[Iterable[zio.aws.s3control.model.S3Tag]] = None,
    redirectLocation: Option[NonEmptyMaxLength2048String] = None,
    requesterPays: Option[Boolean] = None,
    storageClass: Option[zio.aws.s3control.model.S3StorageClass] = None,
    unModifiedSinceConstraint: Option[TimeStamp] = None,
    sseAwsKmsKeyId: Option[KmsKeyArnString] = None,
    targetKeyPrefix: Option[NonEmptyMaxLength1024String] = None,
    objectLockLegalHoldStatus: Option[
      zio.aws.s3control.model.S3ObjectLockLegalHoldStatus
    ] = None,
    objectLockMode: Option[zio.aws.s3control.model.S3ObjectLockMode] = None,
    objectLockRetainUntilDate: Option[TimeStamp] = None,
    bucketKeyEnabled: Option[Boolean] = None,
    checksumAlgorithm: Option[zio.aws.s3control.model.S3ChecksumAlgorithm] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation = {
    import S3CopyObjectOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation
      .builder()
      .optionallyWith(
        targetResource.map(value =>
          S3BucketArnString.unwrap(value): java.lang.String
        )
      )(_.targetResource)
      .optionallyWith(cannedAccessControlList.map(value => value.unwrap))(
        _.cannedAccessControlList
      )
      .optionallyWith(
        accessControlGrants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessControlGrants)
      .optionallyWith(metadataDirective.map(value => value.unwrap))(
        _.metadataDirective
      )
      .optionallyWith(
        modifiedSinceConstraint.map(value => TimeStamp.unwrap(value): Instant)
      )(_.modifiedSinceConstraint)
      .optionallyWith(newObjectMetadata.map(value => value.buildAwsValue()))(
        _.newObjectMetadata
      )
      .optionallyWith(
        newObjectTagging.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.newObjectTagging)
      .optionallyWith(
        redirectLocation.map(value =>
          NonEmptyMaxLength2048String.unwrap(value): java.lang.String
        )
      )(_.redirectLocation)
      .optionallyWith(requesterPays.map(value => value: java.lang.Boolean))(
        _.requesterPays
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        unModifiedSinceConstraint.map(value => TimeStamp.unwrap(value): Instant)
      )(_.unModifiedSinceConstraint)
      .optionallyWith(
        sseAwsKmsKeyId.map(value =>
          KmsKeyArnString.unwrap(value): java.lang.String
        )
      )(_.sseAwsKmsKeyId)
      .optionallyWith(
        targetKeyPrefix.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.targetKeyPrefix)
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(
        objectLockRetainUntilDate.map(value => TimeStamp.unwrap(value): Instant)
      )(_.objectLockRetainUntilDate)
      .optionallyWith(bucketKeyEnabled.map(value => value: java.lang.Boolean))(
        _.bucketKeyEnabled
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly =
    zio.aws.s3control.model.S3CopyObjectOperation.wrap(buildAwsValue())
}
object S3CopyObjectOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3CopyObjectOperation =
      zio.aws.s3control.model.S3CopyObjectOperation(
        targetResource.map(value => value),
        cannedAccessControlList.map(value => value),
        accessControlGrants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metadataDirective.map(value => value),
        modifiedSinceConstraint.map(value => value),
        newObjectMetadata.map(value => value.asEditable),
        newObjectTagging.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        redirectLocation.map(value => value),
        requesterPays.map(value => value),
        storageClass.map(value => value),
        unModifiedSinceConstraint.map(value => value),
        sseAwsKmsKeyId.map(value => value),
        targetKeyPrefix.map(value => value),
        objectLockLegalHoldStatus.map(value => value),
        objectLockMode.map(value => value),
        objectLockRetainUntilDate.map(value => value),
        bucketKeyEnabled.map(value => value),
        checksumAlgorithm.map(value => value)
      )
    def targetResource: Option[S3BucketArnString]
    def cannedAccessControlList
        : Option[zio.aws.s3control.model.S3CannedAccessControlList]
    def accessControlGrants
        : Option[List[zio.aws.s3control.model.S3Grant.ReadOnly]]
    def metadataDirective: Option[zio.aws.s3control.model.S3MetadataDirective]
    def modifiedSinceConstraint: Option[TimeStamp]
    def newObjectMetadata
        : Option[zio.aws.s3control.model.S3ObjectMetadata.ReadOnly]
    def newObjectTagging: Option[List[zio.aws.s3control.model.S3Tag.ReadOnly]]
    def redirectLocation: Option[NonEmptyMaxLength2048String]
    def requesterPays: Option[Boolean]
    def storageClass: Option[zio.aws.s3control.model.S3StorageClass]
    def unModifiedSinceConstraint: Option[TimeStamp]
    def sseAwsKmsKeyId: Option[KmsKeyArnString]
    def targetKeyPrefix: Option[NonEmptyMaxLength1024String]
    def objectLockLegalHoldStatus
        : Option[zio.aws.s3control.model.S3ObjectLockLegalHoldStatus]
    def objectLockMode: Option[zio.aws.s3control.model.S3ObjectLockMode]
    def objectLockRetainUntilDate: Option[TimeStamp]
    def bucketKeyEnabled: Option[Boolean]
    def checksumAlgorithm: Option[zio.aws.s3control.model.S3ChecksumAlgorithm]
    def getTargetResource: ZIO[Any, AwsError, S3BucketArnString] =
      AwsError.unwrapOptionField("targetResource", targetResource)
    def getCannedAccessControlList: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3CannedAccessControlList
    ] = AwsError.unwrapOptionField(
      "cannedAccessControlList",
      cannedAccessControlList
    )
    def getAccessControlGrants
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.S3Grant.ReadOnly]] =
      AwsError.unwrapOptionField("accessControlGrants", accessControlGrants)
    def getMetadataDirective
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3MetadataDirective] =
      AwsError.unwrapOptionField("metadataDirective", metadataDirective)
    def getModifiedSinceConstraint: ZIO[Any, AwsError, TimeStamp] = AwsError
      .unwrapOptionField("modifiedSinceConstraint", modifiedSinceConstraint)
    def getNewObjectMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3ObjectMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("newObjectMetadata", newObjectMetadata)
    def getNewObjectTagging
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      AwsError.unwrapOptionField("newObjectTagging", newObjectTagging)
    def getRedirectLocation: ZIO[Any, AwsError, NonEmptyMaxLength2048String] =
      AwsError.unwrapOptionField("redirectLocation", redirectLocation)
    def getRequesterPays: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterPays", requesterPays)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getUnModifiedSinceConstraint: ZIO[Any, AwsError, TimeStamp] = AwsError
      .unwrapOptionField("unModifiedSinceConstraint", unModifiedSinceConstraint)
    def getSseAwsKmsKeyId: ZIO[Any, AwsError, KmsKeyArnString] =
      AwsError.unwrapOptionField("sseAwsKmsKeyId", sseAwsKmsKeyId)
    def getTargetKeyPrefix: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("targetKeyPrefix", targetKeyPrefix)
    def getObjectLockLegalHoldStatus: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3ObjectLockLegalHoldStatus
    ] = AwsError.unwrapOptionField(
      "objectLockLegalHoldStatus",
      objectLockLegalHoldStatus
    )
    def getObjectLockMode
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockMode)
    def getObjectLockRetainUntilDate: ZIO[Any, AwsError, TimeStamp] = AwsError
      .unwrapOptionField("objectLockRetainUntilDate", objectLockRetainUntilDate)
    def getBucketKeyEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation
  ) extends zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly {
    override val targetResource: Option[S3BucketArnString] = scala
      .Option(impl.targetResource())
      .map(value => zio.aws.s3control.model.primitives.S3BucketArnString(value))
    override val cannedAccessControlList
        : Option[zio.aws.s3control.model.S3CannedAccessControlList] = scala
      .Option(impl.cannedAccessControlList())
      .map(value =>
        zio.aws.s3control.model.S3CannedAccessControlList.wrap(value)
      )
    override val accessControlGrants
        : Option[List[zio.aws.s3control.model.S3Grant.ReadOnly]] = scala
      .Option(impl.accessControlGrants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.S3Grant.wrap(item)
        }.toList
      )
    override val metadataDirective
        : Option[zio.aws.s3control.model.S3MetadataDirective] = scala
      .Option(impl.metadataDirective())
      .map(value => zio.aws.s3control.model.S3MetadataDirective.wrap(value))
    override val modifiedSinceConstraint: Option[TimeStamp] = scala
      .Option(impl.modifiedSinceConstraint())
      .map(value => zio.aws.s3control.model.primitives.TimeStamp(value))
    override val newObjectMetadata
        : Option[zio.aws.s3control.model.S3ObjectMetadata.ReadOnly] = scala
      .Option(impl.newObjectMetadata())
      .map(value => zio.aws.s3control.model.S3ObjectMetadata.wrap(value))
    override val newObjectTagging
        : Option[List[zio.aws.s3control.model.S3Tag.ReadOnly]] = scala
      .Option(impl.newObjectTagging())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.S3Tag.wrap(item)
        }.toList
      )
    override val redirectLocation: Option[NonEmptyMaxLength2048String] = scala
      .Option(impl.redirectLocation())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength2048String(value)
      )
    override val requesterPays: Option[Boolean] =
      scala.Option(impl.requesterPays()).map(value => value: Boolean)
    override val storageClass: Option[zio.aws.s3control.model.S3StorageClass] =
      scala
        .Option(impl.storageClass())
        .map(value => zio.aws.s3control.model.S3StorageClass.wrap(value))
    override val unModifiedSinceConstraint: Option[TimeStamp] = scala
      .Option(impl.unModifiedSinceConstraint())
      .map(value => zio.aws.s3control.model.primitives.TimeStamp(value))
    override val sseAwsKmsKeyId: Option[KmsKeyArnString] = scala
      .Option(impl.sseAwsKmsKeyId())
      .map(value => zio.aws.s3control.model.primitives.KmsKeyArnString(value))
    override val targetKeyPrefix: Option[NonEmptyMaxLength1024String] = scala
      .Option(impl.targetKeyPrefix())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
      )
    override val objectLockLegalHoldStatus
        : Option[zio.aws.s3control.model.S3ObjectLockLegalHoldStatus] = scala
      .Option(impl.objectLockLegalHoldStatus())
      .map(value =>
        zio.aws.s3control.model.S3ObjectLockLegalHoldStatus.wrap(value)
      )
    override val objectLockMode
        : Option[zio.aws.s3control.model.S3ObjectLockMode] = scala
      .Option(impl.objectLockMode())
      .map(value => zio.aws.s3control.model.S3ObjectLockMode.wrap(value))
    override val objectLockRetainUntilDate: Option[TimeStamp] = scala
      .Option(impl.objectLockRetainUntilDate())
      .map(value => zio.aws.s3control.model.primitives.TimeStamp(value))
    override val bucketKeyEnabled: Option[Boolean] =
      scala.Option(impl.bucketKeyEnabled()).map(value => value: Boolean)
    override val checksumAlgorithm
        : Option[zio.aws.s3control.model.S3ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value => zio.aws.s3control.model.S3ChecksumAlgorithm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation
  ): zio.aws.s3control.model.S3CopyObjectOperation.ReadOnly = new Wrapper(impl)
}
