package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3AccessControlPolicy(
    accessControlList: Option[zio.aws.s3control.model.S3AccessControlList] =
      None,
    cannedAccessControlList: Option[
      zio.aws.s3control.model.S3CannedAccessControlList
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3AccessControlPolicy = {
    import S3AccessControlPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3AccessControlPolicy
      .builder()
      .optionallyWith(accessControlList.map(value => value.buildAwsValue()))(
        _.accessControlList
      )
      .optionallyWith(cannedAccessControlList.map(value => value.unwrap))(
        _.cannedAccessControlList
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3AccessControlPolicy.ReadOnly =
    zio.aws.s3control.model.S3AccessControlPolicy.wrap(buildAwsValue())
}
object S3AccessControlPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3AccessControlPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3AccessControlPolicy =
      zio.aws.s3control.model.S3AccessControlPolicy(
        accessControlList.map(value => value.asEditable),
        cannedAccessControlList.map(value => value)
      )
    def accessControlList
        : Option[zio.aws.s3control.model.S3AccessControlList.ReadOnly]
    def cannedAccessControlList
        : Option[zio.aws.s3control.model.S3CannedAccessControlList]
    def getAccessControlList: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3AccessControlList.ReadOnly
    ] = AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getCannedAccessControlList: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3CannedAccessControlList
    ] = AwsError.unwrapOptionField(
      "cannedAccessControlList",
      cannedAccessControlList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3AccessControlPolicy
  ) extends zio.aws.s3control.model.S3AccessControlPolicy.ReadOnly {
    override val accessControlList
        : Option[zio.aws.s3control.model.S3AccessControlList.ReadOnly] = scala
      .Option(impl.accessControlList())
      .map(value => zio.aws.s3control.model.S3AccessControlList.wrap(value))
    override val cannedAccessControlList
        : Option[zio.aws.s3control.model.S3CannedAccessControlList] = scala
      .Option(impl.cannedAccessControlList())
      .map(value =>
        zio.aws.s3control.model.S3CannedAccessControlList.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3AccessControlPolicy
  ): zio.aws.s3control.model.S3AccessControlPolicy.ReadOnly = new Wrapper(impl)
}
