package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.s3control.model.primitives.{
  NonEmptyMaxLength64String,
  S3RegionalBucketArn,
  PublicAccessBlockEnabled,
  BucketName,
  CreationDate
}
import scala.jdk.CollectionConverters.*
final case class RegionalBucket(
    bucket: BucketName,
    bucketArn: Option[S3RegionalBucketArn] = None,
    publicAccessBlockEnabled: PublicAccessBlockEnabled,
    creationDate: CreationDate,
    outpostId: Option[NonEmptyMaxLength64String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.RegionalBucket = {
    import RegionalBucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.RegionalBucket
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        bucketArn.map(value =>
          S3RegionalBucketArn.unwrap(value): java.lang.String
        )
      )(_.bucketArn)
      .publicAccessBlockEnabled(
        PublicAccessBlockEnabled.unwrap(
          publicAccessBlockEnabled
        ): java.lang.Boolean
      )
      .creationDate(CreationDate.unwrap(creationDate): Instant)
      .optionallyWith(
        outpostId.map(value =>
          NonEmptyMaxLength64String.unwrap(value): java.lang.String
        )
      )(_.outpostId)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.RegionalBucket.ReadOnly =
    zio.aws.s3control.model.RegionalBucket.wrap(buildAwsValue())
}
object RegionalBucket {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.RegionalBucket
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.RegionalBucket =
      zio.aws.s3control.model.RegionalBucket(
        bucket,
        bucketArn.map(value => value),
        publicAccessBlockEnabled,
        creationDate,
        outpostId.map(value => value)
      )
    def bucket: BucketName
    def bucketArn: Option[S3RegionalBucketArn]
    def publicAccessBlockEnabled: PublicAccessBlockEnabled
    def creationDate: CreationDate
    def outpostId: Option[NonEmptyMaxLength64String]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getBucketArn: ZIO[Any, AwsError, S3RegionalBucketArn] =
      AwsError.unwrapOptionField("bucketArn", bucketArn)
    def getPublicAccessBlockEnabled
        : ZIO[Any, Nothing, PublicAccessBlockEnabled] =
      ZIO.succeed(publicAccessBlockEnabled)
    def getCreationDate: ZIO[Any, Nothing, CreationDate] =
      ZIO.succeed(creationDate)
    def getOutpostId: ZIO[Any, AwsError, NonEmptyMaxLength64String] =
      AwsError.unwrapOptionField("outpostId", outpostId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.RegionalBucket
  ) extends zio.aws.s3control.model.RegionalBucket.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val bucketArn: Option[S3RegionalBucketArn] = scala
      .Option(impl.bucketArn())
      .map(value =>
        zio.aws.s3control.model.primitives.S3RegionalBucketArn(value)
      )
    override val publicAccessBlockEnabled: PublicAccessBlockEnabled =
      zio.aws.s3control.model.primitives
        .PublicAccessBlockEnabled(impl.publicAccessBlockEnabled())
    override val creationDate: CreationDate =
      zio.aws.s3control.model.primitives.CreationDate(impl.creationDate())
    override val outpostId: Option[NonEmptyMaxLength64String] = scala
      .Option(impl.outpostId())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength64String(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.RegionalBucket
  ): zio.aws.s3control.model.RegionalBucket.ReadOnly = new Wrapper(impl)
}
