package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.BucketName
import scala.jdk.CollectionConverters.*
final case class Region(bucket: BucketName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.Region = {
    import Region.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.Region
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.Region.ReadOnly =
    zio.aws.s3control.model.Region.wrap(buildAwsValue())
}
object Region {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3control.model.Region] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.Region =
      zio.aws.s3control.model.Region(bucket)
    def bucket: BucketName
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.Region
  ) extends zio.aws.s3control.model.Region.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.Region
  ): zio.aws.s3control.model.Region.ReadOnly = new Wrapper(impl)
}
